;(function () {
	'use strict';
	
	// zmienne
	var cicrle = document.querySelector(".circle");
	var circlePath = document.querySelector(".circle path");
	var pathLength = circlePath.getTotalLength();
	var pathLengthPx = pathLength  + "px";
	var animateButton = document.querySelector(".animate");
	var text = document.querySelector(".circle text");
	var rangeField = document.querySelector(".range");
	
	// ustawienie kolorów
	var strokeStartColour = "#333333";
	var strokeEndColour = "#ff9900";
	
	// funkcja główna
	var radial = {
		initialisePath: function() {
			// funkcja ta resetuje licznik do animacji
			
			//  najpierw ustawiamy własność strokeDashoffset na długość ścieżki
			// uwaga: można usunąć łańcuch z łącznikiem, aby odwrócić kierunek animacji
			circlePath.style.strokeDashoffset = "-" + pathLength;
			// ustawienie własności strokeDashArray
			circlePath.style.strokeDasharray = pathLength  + ' ' + pathLength;

			// reset koloru linii
			circlePath.style.stroke = strokeStartColour;
		},

		animateClick: function() {	
			// funkcja nasłuchująca zmian w polu wejściowym i
			// ustawiająca atrybut wartości na tę wartość
			
			// aktualizuje wartość pola, gdy następuje zmiana wartości
			var inputField = document.querySelector(".enterValue");
			
			inputField.addEventListener("input", function(){
				this.setAttribute("value", this.value);
			}, false);
			
			// przekazanie wartości z pola wejściowego w reakcji na naciśnięcie przycisku
			animateButton.addEventListener('click', function() {
				var input = document.querySelector(".enterValue").value;
				var lineLengthFromInput = pathLength - (pathLength / 100 * input);
				radial.animateSVG(lineLengthFromInput, input);
			}, false);
		},

		// animacja
		animateSVG: function(amount, inputValue) {
			// funkcja ta najpierw resetuje animację
			radial.initialisePath();
			// animacja rysowania i zmiany koloru linii
			TweenLite.to(circlePath, 1.5, {'stroke-dashoffset': "-"+amount, stroke: strokeEndColour});
			// ustawienie licznika na zero i animacja wartości w polu wejściowym
			var counter = { var: 0 };
			TweenLite.to(counter, 1.5, {
				var: inputValue,
				onUpdate: function () {
					text.textContent = Math.ceil(counter.var) + "%";
				},
				ease:Circ.easeOut
			});
		},

		changeWidth: function() {
			// funkcja zmieniająca szerokość linii licznika przez nasłuchiwanie
			// zmian w polu wejściowym i stosowanie wykrytej wartości jako szerokości linii

			// aktualizacja wartości pola, gdy zmieni się wartość
			rangeField.addEventListener("input", function(){
				// this.setAttribute("value", this.value);
				circlePath.style.strokeWidth = this.value + "px";
			}, false);
		}
	};
	// uruchomienie wszystkiego
	radial.changeWidth();
	radial.initialisePath();
	radial.animateClick();
})();