#!/bin/bash
#
# Plik konfiguracyjny @PKG_NAME@.
# $Id$

# Lokalizacja tego pliku konfiguracyjnego po zainstalowaniu go.
APP_ENV="@PKG_ROOT@/conf/@PKG_NAME@-env.sh"

# Pooenie instalacji rodowiska Java. Niestety lokalizacja ta musi
# by na sztywno okrelona w kodzie, gdy zmienna JAVA_HOME w obrbie
# komputera procesu budowania moe nie by poprawna w przypadku komputera,
# na ktrym wdroono aplikacj WWW.
JAVA_HOME="/usr/java/jdk1.6.0_01"

# Lokalizacja instalacji serwera Tomcat.
CATALINA_HOME="@PKG_ROOT@"
JASPER_HOME="@PKG_ROOT@"
CATALINA_TMPDIR="@PKG_ROOT@/temp"

# cieka zapisywalnego drzewa katalogowego Tomcata uywanego przez aplikacj.
CATALINA_BASE="@PKG_ROOT@"

# Identyfikator maszyny JVM pakietu.
JVM_ID="@JVM_ID@"

# Jeli w obrbie maszyny JVM zamierza si uruchomi debugger JPDA (serwer), 
# naley usun znak komentarza z poniszego wiersza zmiennej JPDA_OPTS.
#JPDA_OPTS="-Xdebug \
#  -Xrunjdwp:transport=dt_socket,address=8000,server=y,suspend=n"

# Uywajc rodowiska Java w wersji 1.5 ("Java 5") lub nowszej, mona ustawi 
# zmienn JMX_OPTS, eby uaktywni wbudowane zcze agenta monitorowania/zarzdzania
# JMX. W celu poczenia si ze zczem naley zastosowa narzdzie jconsole.
# Wicej informacji pod adresem: 
# http://java.sun.com/j2se/1.5.0/docs/guide/management/agent.html
#
# W celu uaktywnienia agenta JMX tylko dla lokalnego hosta naley usun
# znaki komentarza z poniszych wierszy.
#JMX_OPTS="-Dcom.sun.management.jmxremote=true \
#  -Dcom.sun.management.jmxremote.ssl=false \
#  -Dcom.sun.management.jmxremote.authenticate=false"
#
# W celu wczenia zdalnego agenta JMX naley usun
# znaki komentarza z poniszych wierszy.
#JMX_OPTS="-Dcom.sun.management.jmxremote.port=8008 \

#  -Dcom.sun.management.jmxremote.ssl=false \
#  -Dcom.sun.management.jmxremote.authenticate=false \
#  -Dcom.sun.management.jmxremote.password.file=/path/to/pw/file"

# W razie potrzeby w poniszym wierszu mona umieci dodatkowe parametry
# startowe dla wirtualnej maszyny Java.
JAVA_OPTS="-Djvm=$JVM_ID -Xms384M -Xmx384M -Djava.awt.headless=true \
  -Djava.net.preferIPv4Stack=true $JPDA_OPTS $JMX_OPTS"

# W celu uaktywnienia narzdzia SecurityManager i okrelenia pliku zasad
# zabezpiecze znak komentarza naley usun z poniszych wierszy. Jeli
# nie ustawi si cieki tego pliku, domylnie zostanie uyty plik o ciece
# $CATALINA_BASE/conf/catalina.policy. UWAGA: ponisze wiersze powinny pozosta
# komentarzami w przypadku niemal wszystkich instalacji serwera Tomcat!
#JAVA_OPTS="$JAVA_OPTS -Djava.security.manager \
#  -Djava.security.policy=$CATALINA_BASE/conf/catalina.policy"

# Dla opcji tej naley usun znak komentarza, aby z narzdzia SecurityManager
# uzyska informacje dotyczce debugowania maszyny JVM.
#JAVA_OPTS="$JAVA_OPTS -Djava.security.debug=all"

# Dla opcji tej naley usun znak komentarza, aby okreli implementacj menedera zabezpiecze.
#JAVA_OPTS="$JAVA_OPTS -Djava.security.manager=[put-class-name-here]"

# Dla opcji tej naley usun znak komentarza, eby maszyna JVM zwrcia
# szczegowe informacje dotyczce zawartoci sterty (jeli pojawi si
# wyjtek OutOfMemoryError. Inna metoda sprawdzenia sterty polega na uyciu
# polecenia jmap -heap:format.
#JAVA_OPTS="$JAVA_OPTS -XX:+HeapDumpOnOutOfMemoryError"

# Uytkownik, ktry powinien uruchomi serwer Tomcat.
TOMCAT_USER="@TOMCAT_USER@"

# Poniszy wiersz umoliwia okrelenie ustawie jzykowych dla serwera Tomcat.
# Domylnie s stosowane standardowe ustawienia jzykowe systemu operacyjnego
# okrelone podczas instalacji.
#LANG=en_US

# Czas (w sekundach), jaki upywa przed wysaniem sygnaw koczcych proces
# maszyny JVM. Cakowity maksymalny czas oczekiwania jest trzykrotnoci niej
# ustawionej wartoci! Pierwszy okres oczekiwania SHUTDOWN_WAIT jest przeznaczony 
# na wyczenie maszyny JVM przez polecenie zatrzymujce Tomcata. Drugi okres 
# oczekiwania SHUTDOWN_WAIT suy sygnaowi SIGTERM, ktry ma wyczy maszyn JVM,
# gdy nie uda si to poleceniu zatrzymujcemu Tomcata. Trzeci okres oczekiwania 
# SHUTDOWN_WAIT ma miejsce po wysaniu sygnau SIGKILL, jeli sygna SIGTERM nie
# by w stanie wyczy maszyny JVM.
let SHUTDOWN_WAIT=2

# Jeli zamierza si dodatkowo dostosowa rodowisko Tomcata, poniej naley
# wstawi wasne definicje (na przykad zmienn LD_LIBRARY_PATH dla katalogu
# bibliotek zcza APR, bibliotek sterownikw JDBC itp.). Nie wolno jedynie
# zapomnie o wyeksportowaniu tych definicji.
#
# Jeeli planuje si uycie zcza APR, dla zmiennej LD_LIBRARY_PATH
# naley ustawi katalog zawierajcy plik wsplnej biblioteki libtcnative-1.so.0
# (by moe w nazwie pliku bd widoczne numery nowszej wersji).
#export LD_LIBRARY_PATH=/opt/tomcat/apr-connector/lib

# package.version okrela numer gwnej wersji pakietu.
# Zwykle uywany jest format "x.y.z", w ktrym x oznacza numer gwnej
# wersji, y numer dodatkowej wersji, a z numer poprawki wersji.
# Nie s dozwolone spacje ani znak -.
package.version=6.0.xy

# package.rev okrela numer mniej istotnej modyfikacji pakietu.
#
# Narzdzie RPM pozwala na umieszczanie w wartoci waciwoci package.rev
# znakw alfanumerycznych, znakw podkrelenia i kropek.
package.rev=1