//: c15:servlets:SessionPeek.java
// Wykorzystanie klasy HttpSession.
import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
public class SessionPeek extends HttpServlet { 
  public void service(HttpServletRequest req, 
  HttpServletResponse res)
  throws ServletException, IOException {
    // Wycignij obiekt Session, zanim
    // cokolwiek zostanie wysane do klienta.
    HttpSession session = req.getSession();
    res.setContentType("text/html");
    PrintWriter out = res.getWriter();
    out.println("<HEAD><TITLE> SessionPeek ");
    out.println(" </TITLE></HEAD><BODY>");
    out.println("<h1> SessionPeek </h1>");
    // Prosty licznik odwoa dla danej sesji.
    Integer ival = (Integer) 
      session.getAttribute("sesspeek.cntr");
    if(ival==null) 
      ival = new Integer(1);
    else 
      ival = new Integer(ival.intValue() + 1);
    session.setAttribute("sesspeek.cntr", ival);
    out.println("Pobrae t stron <b>"
      + ival + "</b> razy.<p>");
    out.println("<h2>");
    out.println("Dane sesji zapisane </h2>");
    // Iteracja po wszystkich danych w sesji:
    Enumeration sesNames = 
      session.getAttributeNames();
    while(sesNames.hasMoreElements()) {
      String name = 
        sesNames.nextElement().toString();
      Object value = session.getAttribute(name);
      out.println(name + " = " + value + "<br>");
    }
    out.println("<h3> Statystyka sesji </h3>");
    out.println("Identyfikator sesji: " 
      + session.getId() + "<br>");
    out.println("Czy jest nowa: " + session.isNew()
      + "<br>");
    out.println("Czas powstania: "
      + session.getCreationTime());
    out.println("<I>(" + 
      new Date(session.getCreationTime())
      + ")</I><br>");
    out.println("Czas ostatniego dostpu: " +
      session.getLastAccessedTime());
    out.println("<I>(" +
      new Date(session.getLastAccessedTime())
      + ")</I><br>");
    out.println("Maksymalny czas nieaktywnoci: "
      + session.getMaxInactiveInterval());
    out.println("Identyfikator sesji w zadaniu: "
      + req.getRequestedSessionId() + "<br>");
    out.println("Czy identyfikator sesji pobrany z ciasteczka: "
      + req.isRequestedSessionIdFromCookie()
      + "<br>");
    out.println("Czy identyfikator sesji pobrany z adresu URL: "
      + req.isRequestedSessionIdFromURL()
      + "<br>");
    out.println("Czy identyfikator sesji jest wany: "
      + req.isRequestedSessionIdValid()
      + "<br>");
    out.println("</BODY>");
    out.close();
  }
  public String getServletInfo() {
    return "Serwlet ledzcy sesj";
  }
} ///:~
