//: c15:MultiJabberServer.java
// Serwer wykorzystujcy wielowtkowo w celu 
// obsugi dowolnej liczby klientw
import java.io.*;
import java.net.*;

class ServeOneJabber extends Thread {
  private Socket socket;
  private BufferedReader in;
  private PrintWriter out;
  public ServeOneJabber(Socket s) 
      throws IOException {
    socket = s;
    in = 
      new BufferedReader(
        new InputStreamReader(
          socket.getInputStream()));
    // Wcz automatyczne oprnianie bufora:
    out = 
      new PrintWriter(
        new BufferedWriter(
          new OutputStreamWriter(
            socket.getOutputStream())), true);
    // Jeeli jedno z powyszych wywoa zgosi wyjtek,
    // wtedy wywoujcy jest odpowiedzialny za zamknicie
    // gniazda. W przeciwnym wypadku zamknie je 
    // wtek.
    start(); // Wywouje run()
  }
  public void run() {
    try {
      while (true) {  
        String str = in.readLine();
        if (str.equals("KONIEC")) break;
        System.out.println("Echo: " + str);
        out.println(str);
      }
      System.out.println("zamykamy...");
    } catch(IOException e) {
      System.err.println("IO Exception");
    } finally {
      try {
        socket.close();
      } catch(IOException e) {
        System.err.println("Gniazdo nie zamknite");
      }
    }
  }
}

public class MultiJabberServer {  
  static final int PORT = 8080;
  public static void main(String[] args)
      throws IOException {
    ServerSocket s = new ServerSocket(PORT);
    System.out.println("Serwer wystartowa");
    try {
      while(true) {
        // Przerywa wykonanie czekajc na poczenie:
        Socket socket = s.accept();
        try {
          new ServeOneJabber(socket);
        } catch(IOException e) {
          // Jeeli si nie powiedzie - zamknij gniazdo,
          // w przeciwnym wypadku zamknie je wtek:
          socket.close();
        }
      }
    } finally {
      s.close();
    }
  } 
} ///:~
