//: c14:ThreadGroup1.java
// Jak grupy wtku kontroluj priorytety
// wtkw w nich zamieszczonych.

public class ThreadGroup1 {
  public static void main(String[] args) {
    // Pobierz wtek systemowy i wypisz informacje o nim:
    ThreadGroup sys = 
      Thread.currentThread().getThreadGroup();
    sys.list(); // (1)
    // Ograniczenie priorytetu grupy systemowej:
    sys.setMaxPriority(Thread.MAX_PRIORITY - 1);
    // Zwikszenie priorytetu gwnego wtku:
    Thread curr = Thread.currentThread();
    curr.setPriority(curr.getPriority() + 1);
    sys.list(); // (2)
    // Prba ustawienia priorytetu nowej grupy na maksymalny:
    ThreadGroup g1 = new ThreadGroup("g1");
    g1.setMaxPriority(Thread.MAX_PRIORITY);
    // Prba ustawienia priorytetu nowej grupy na maksymalny:
    Thread t = new Thread(g1, "A");
    t.setPriority(Thread.MAX_PRIORITY);
    g1.list(); // (3)
    // Ograniczenie maksymalnego priorytetu dla g1, 
    // a nastpnie prba jego inkrementacji:
    g1.setMaxPriority(Thread.MAX_PRIORITY - 2);
    g1.setMaxPriority(Thread.MAX_PRIORITY);
    g1.list(); // (4)
    // Prba ustawienia priorytetu nowej grupy na maksymalny:
    t = new Thread(g1, "B");
    t.setPriority(Thread.MAX_PRIORITY);
    g1.list(); // (5)
    // Obnienie maksymalnego priorytetu poniej domylnego
    // priorytetu wtku:
    g1.setMaxPriority(Thread.MIN_PRIORITY + 2);
    // Spojrzenie na priorytet nowego wtku przed
    // i po jego zmianie:
    t = new Thread(g1, "C");
    g1.list(); // (6)
    t.setPriority(t.getPriority() -1);
    g1.list(); // (7)
    // Zamieszczenie g2 jako podgrupy g1 i prba
    // zwikszenia jej priorytetu:
    ThreadGroup g2 = new ThreadGroup(g1, "g2");
    g2.list(); // (8)
    g2.setMaxPriority(Thread.MAX_PRIORITY);
    g2.list(); // (9)
    // Dodaj grup nowych wtkw do g2:
    for (int i = 0; i < 5; i++)
      new Thread(g2, Integer.toString(i));
    // Poka informacje o wszystkich grupach
    // wtkw i o wtkach:
    sys.list(); // (10)
    System.out.println("Uruchomienie wtkw:");
    Thread[] all = new Thread[sys.activeCount()];
    sys.enumerate(all);
    for(int i = 0; i < all.length; i++) 
      if(!all[i].isAlive())  //null != all[i] && 
        all[i].start();
    // Zawie i zatrzymaj wszystkie wtki
    // w tej grupie i jej podgrupach:
    System.out.println("Wszystkie wtki uruchomione");
    sys.suspend(); // Nie zalecane w Java 2
    // Program nigdy tu nie dojdzie...
    System.out.println("Wszystkie wtki zawieszone");
    sys.stop(); // Nie zalecane w Java 2
    System.out.println("Wszystkie wtki zatrzymane");
  }
} ///:~
