//: c12:ShowMethodsClean.java
// ShowMethods z wyczonymi ucileniami
// aby uczyni wynik atwiejszym w odczycie.
import java.lang.reflect.*;
import com.bruceeckel.util.*;

public class ShowMethodsClean {
  static final String usage =
    "Uycie: \n" +
    "ShowMethods nazwa.klasy\n" +
    "aby pokaza wszystkie metody z klasy lub: \n" +
    "ShowMethods nazwa.klasy\n" +
    "aby poszuka metody o sygnaturze zawierajcej 'sowo'";
  public static void main(String[] args) {
    if(args.length < 1) {
      System.out.println(usage);
      System.exit(0);
    }
    try {
      Class c = Class.forName(args[0]);
      Method[] m = c.getMethods();
      Constructor[] ctor = c.getConstructors();
      // Zamiana na tablic przefiltrowan:
      String[] n = 
        new String[m.length + ctor.length];
      for(int i = 0; i < m.length; i++) {
        String s = m[i].toString();
        n[i] = StripQualifiers.strip(s);
      }
      for(int i = 0; i < ctor.length; i++) {
        String s = ctor[i].toString();
        n[i + m.length] = 
          StripQualifiers.strip(s);
      }
      if(args.length == 1)
        for (int i = 0; i < n.length; i++)
          System.out.println(n[i]);
      else
        for (int i = 0; i < n.length; i++)
          if(n[i].indexOf(args[1])!= -1)
            System.out.println(n[i]);
    } catch(ClassNotFoundException e) {
      System.err.println("Nie ma takiej klasy: " + e);
    }
  }
} ///:~
