//: c08:controller:Controller.java
// Oglny szkielet wszelkich systemw
// sterujcych (w poczeniu z klas Event):
package c08.controller;

// Ponisza klasa przechowuje jedynie obiekty Event.
class EventSet {
  private Event[] events = new Event[100];
  private int index = 0;
  private int next = 0;
  public void add(Event e) {
    if(index >= events.length)
      return; // (lepiej zgosi wyjtek)
    events[index++] = e;
  }
  public Event getNext() {
    boolean looped = false;
    int start = next;
    do {
      next = (next + 1) % events.length;
      // Sprawdmy, czy zrobilimy pen ptl:
      if(start == next) looped = true;
      // Jeeli przeszlimy poza start, to znaczy, 
      // e lista jest pusta:
      if((next == (start + 1) % events.length)
         && looped)
        return null;
    } while(events[next] == null);
    return events[next];
  }
  public void removeCurrent() {
    events[next] = null;
  }
}
public class Controller {
  private EventSet es = new EventSet();
  public void addEvent(Event c) { es.add(c); }
  public void run() {
    Event e;
    while((e = es.getNext()) != null) {
      if(e.ready()) {
        e.action();
        System.out.println(e.description());
        es.removeCurrent();
      }
    }
  }
} ///:~
