//: c15:rmi:PerfectTime.java
// Implementacja odlegego
// obiektu PerfectTime.
package c15.rmi;
import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import java.net.*;

public class PerfectTime 
extends UnicastRemoteObject
implements PerfectTimeI {
  // Implementacja interfejsu:
  public long getPerfectTime() 
      throws RemoteException {
    return System.currentTimeMillis();
  }
  // Konieczna implementacja konstruktora
  // by wyrzuca wyjtek RemoteException:
  public PerfectTime() throws RemoteException {
    // super(); // Nastpi automatycznie
  }
  // Rejestracja serwisu RMI. Wyrzucenie
  // wyjtkw na konsol.
  public static void main(String[] args) 
  throws Exception {
    System.setSecurityManager(
    new RMISecurityManager());
    PerfectTime pt = new PerfectTime();
    Naming.bind(
      "//peppy:2005/PerfectTime", pt);
    System.out.println("Gotowy do podawania czasu");
  }
} ///:~
