//: c09:ReadOnly.java
// Zastosowanie metod Collections.unmodifiable.
import java.util.*;
import com.bruceeckel.util.*;

public class ReadOnly {
  static Collections2.StringGenerator gen = 
    Collections2.countries;
  public static void main(String[] args) {
    Collection c = new ArrayList();
    Collections2.fill(c, gen, 25); // Wstaw dane
    c = Collections.unmodifiableCollection(c);
    System.out.println(c); // Odczyt jest OK
    c.add("jeden"); // Nie mona zmieni
    
    List a = new ArrayList();
    Collections2.fill(a, gen.reset(), 25);
    a = Collections.unmodifiableList(a);
    ListIterator lit = a.listIterator();
    System.out.println(lit.next()); // Odczyt jest OK
    lit.add("jeden"); // Nie mona zmieni

    Set s = new HashSet();
    Collections2.fill(s, gen.reset(), 25);
    s = Collections.unmodifiableSet(s);
    System.out.println(s); // Odczyt jest OK
    //! s.add("jeden"); // Nie mona zmieni
    
    Map m = new HashMap();
    Collections2.fill(m,
      Collections2.geography, 25);
    m = Collections.unmodifiableMap(m);
    System.out.println(m); // Odczyt jest OK
    //! m.put("Ralph", "Witaj!");
  }
} ///:~
