//: c09:Map1.java
// To, co mona zrobi z odwzorowaniami Map.

import java.util.*;
import com.bruceeckel.util.*;
public class Map1 {
  static Collections2.StringPairGenerator geo = 
    Collections2.geography;
  static Collections2.RandStringPairGenerator 
    rsp = Collections2.rsp;
  // Przedstawienie zbioru (Set) kluczy:
  public static void printKeys(Map m) {
    System.out.print("Rozmiar = " + m.size() +", ");
    System.out.print("Klucze: ");
    System.out.println(m.keySet());
  }
  // Przedstawienie kolekcji (Collection) wartoci:
  public static void printValues(Map m) {
    System.out.print("Wartoci: ");
    System.out.println(m.values());
  }
  public static void test(Map m) {
    Collections2.fill(m, geo, 25);
    // Odwzorowanie Map wobec kluczy zachowuje si jak 'Set':
    Collections2.fill(m, geo.reset(), 25);
    printKeys(m);
    printValues(m);
    System.out.println(m);
    String key = CountryCapitals.pairs[4][0];
    String value = CountryCapitals.pairs[4][1];
    System.out.println("m.containsKey(\"" + key +
      "\"): " + m.containsKey(key));
    System.out.println("m.get(\"" + key + "\"): "
      + m.get(key));
    System.out.println("m.containsValue(\"" 
      + value + "\"): " + 
      m.containsValue(value)); 
    Map m2 = new TreeMap();
    Collections2.fill(m2, rsp, 25);
    m.putAll(m2);
    printKeys(m);
    key = m.keySet().iterator().next().toString();
    System.out.println("Pierwszy klucz w odwzorowaniu: "+key);
    m.remove(key);
    printKeys(m);
    m.clear();
    System.out.println("m.isEmpty(): " 
      + m.isEmpty());
    Collections2.fill(m, geo.reset(), 25);
    // Operacje na zbiorze kluczy zmieniaj te odwzorowanie:
    m.keySet().removeAll(m.keySet());
    System.out.println("m.isEmpty(): " 
      + m.isEmpty());
  }
  public static void main(String[] args) {
    System.out.println("Analiza HashMap");
    test(new HashMap());
    System.out.println("Analiza TreeMap");
    test(new TreeMap());
  }
} ///:~
