//: c07:Frog.java
// Testowanie metody finalize w zwizku z dziedziczeniem.

class DoBaseFinalization {
  public static boolean flag = false;
}

class Characteristic {
  String s;
  Characteristic(String c) {
    s = c;
    System.out.println(
      "Tworzenie obiektu Characteristic " + s);
  }
  protected void finalize() {
    System.out.println(
      "Finalizacja Characteristic " + s);
  }
}

class LivingCreature {
  Characteristic p = 
    new Characteristic("yje");
  LivingCreature() {
    System.out.println("LivingCreature()");
  }
  protected void finalize() throws Throwable {
    System.out.println(
      "Finalizacja LivingCreature ");
    // Wywoanie wersji z klasy bazowej NA KOCU!
    if(DoBaseFinalization.flag)
      super.finalize();
  }
}

class Animal extends LivingCreature {
  Characteristic p = 
    new Characteristic("ma serce");
  Animal() {
    System.out.println("Animal()");
  }
  protected void finalize() throws Throwable {
    System.out.println("Finalizacja Animal ");
    if(DoBaseFinalization.flag)
      super.finalize();
  }
}

class Amphibian extends Animal {
  Characteristic p = 
    new Characteristic("moe y w wodzie");
  Amphibian() {
    System.out.println("Amphibian()");
  }
  protected void finalize() throws Throwable {
    System.out.println("Finalizacja Amphibian ");
    if(DoBaseFinalization.flag)
      super.finalize();
  }
}

public class Frog extends Amphibian {
  Frog() {
    System.out.println("Frog()");
  }
  protected void finalize() throws Throwable {
    System.out.println("Finalizacja Frog ");
    if(DoBaseFinalization.flag)
      super.finalize();
  }
  public static void main(String[] args) {
    if(args.length != 0 && 
       args[0].equals("finalize"))
       DoBaseFinalization.flag = true;
    else
      System.out.println("Bez finalizacji klas bazowych");
    new Frog(); // Od razu staje si mieciem
    System.out.println("Dobranoc!");
    // Wymuszenie wywoanie finalizatorw:
    System.gc();
  }
} ///:~
