//: appendixa:CopyConstructor.java
// Konstruktor do kopiowania obiektu tego samego
// typu, jako prba stworzenia kopii lokalnej.

class FruitQualities {
  private int weight;
  private int color;
  private int firmness;
  private int ripeness;
  private int smell;
  // itp.
  FruitQualities() { // Konstruktor domylny
    // zrb cos sensownego...
  }
  // Inne konstruktory:
  // ...
  // Konstruktor kopiujcy:
  FruitQualities(FruitQualities f) {
    weight = f.weight;
    color = f.color;
    firmness = f.firmness;
    ripeness = f.ripeness;
    smell = f.smell;
    // itp.
  }
}

class Seed {
  // Skadowe...
  Seed() { /* Konstruktor domylny */ }
  Seed(Seed s) { /* Konstruktor kopiujcy */ }
}

class Fruit {
  private FruitQualities fq;
  private int seeds;
  private Seed[] s;
  Fruit(FruitQualities q, int seedCount) { 
    fq = q;
    seeds = seedCount;
    s = new Seed[seeds];
    for(int i = 0; i < seeds; i++)
      s[i] = new Seed();
  }
  // Inne konstruktory:
  // ...
  // Konstruktor kopiujcy:
  Fruit(Fruit f) {
    fq = new FruitQualities(f.fq);
    seeds = f.seeds;
    s = new Seed[seeds];
    // Wywoaj konstruktory kopiujce wszystkich Seed:
    for(int i = 0; i < seeds; i++) 
      s[i] = new Seed(f.s[i]); 
    // Inne dziaania konstrukcji kopiujcej...
  }
  // Aby pozwoli konstruktorom pochodnym (lub innym
  // metodom) na okrelenie rnych waciwoci:
  protected void addQualities(FruitQualities q) {
    fq = q;
  }
  protected FruitQualities getQualities() {
    return fq;
  }
}

class Tomato extends Fruit {
  Tomato() {
    super(new FruitQualities(), 100);
  }
  Tomato(Tomato t) { // Konstruktor kopiujcy
    super(t); // Przekazanie w gr do konstruktora kopiujcego
    // Pozostae dziaania konstrukcji kopiujcej...
  }
}

class ZebraQualities extends FruitQualities {
  private int stripedness;
  ZebraQualities() { // Konstruktor domylny
    // zrb cos sensownego...
  }
  ZebraQualities(ZebraQualities z) {
    super(z);
    stripedness = z.stripedness;
  }
}

class GreenZebra extends Tomato {
  GreenZebra() {
    addQualities(new ZebraQualities());
  }
  GreenZebra(GreenZebra g) {
    super(g); // Wywoaj Tomato(Tomato)
    // Przywr poprawne waciwoci:
    addQualities(new ZebraQualities());
  }
  void evaluate() {
    ZebraQualities zq = 
      (ZebraQualities)getQualities();
    // Zrb co z tymi waciwociami
    // ...
  }
}

public class CopyConstructor {
  public static void ripen(Tomato t) {
    // Uyj "konstruktora kopiujcego":
    t = new Tomato(t); 
    System.out.println("W ripen, t jest " +
      t.getClass().getName());
  }
  public static void slice(Fruit f) {
    f = new Fruit(f); // Hmmm... czy to zadziaa?
    System.out.println("W slice, f jest " +
      f.getClass().getName());
  }
  public static void main(String[] args) {
    Tomato tomato = new Tomato();
    ripen(tomato); // OK
    slice(tomato); // Ups!
    GreenZebra g = new GreenZebra();
    ripen(g); // Ups!
    slice(g); // Ups!
    g.evaluate();
  }
} ///:~
