//: xml/Person.java
// Zastosowanie biblioteki XOM do zapisu i odczytu dokumentu XML
// {Requires: nu.xom.Node; Wymaga zainstalowania biblioteki XOM
// spod adresu http://www.xom.nu }
import nu.xom.*;
import java.io.*;
import java.util.*;

public class Person {
  private String first, last;
  public Person(String first, String last) {
    this.first = first;
    this.last = last;
  }
  // Tworzy element (Element) XML na bazie obiektu Person (this):
  public Element getXML() {
    Element person = new Element("person");
    Element firstName = new Element("first");
    firstName.appendChild(first);
    Element lastName = new Element("last");
    lastName.appendChild(last);
    person.appendChild(firstName);
    person.appendChild(lastName);
    return person;
  }
  // Konstruktor, przywracajcy obiekt Person z elementu XML:
  public Person(Element person) {
    first= person.getFirstChildElement("first").getValue();
    last = person.getFirstChildElement("last").getValue();
  }
  public String toString() { return first + " " + last; }
  // Gwoli czytelnoci:
  public static void
  format(OutputStream os, Document doc) throws Exception {
    Serializer serializer= new Serializer(os,"Windows-1250");
    serializer.setIndent(4);
    serializer.setMaxLength(60);
    serializer.write(doc);
    serializer.flush();
  }
  public static void main(String[] args) throws Exception {
    List<Person> people = Arrays.asList(
      new Person("Prof. Ambroy", "Kleks"),
      new Person("Alojzy", "Bbel"),
      new Person("Max", "Benson"));
    System.out.println(people);
    Element root = new Element("people");
    for(Person p : people)
      root.appendChild(p.getXML());
    Document doc = new Document(root);
    format(System.out, doc);
    format(new BufferedOutputStream(new FileOutputStream(
      "People.xml")), doc);
  }
} /* Output:
[Prof. Ambroy Kleks, Alojzy Bbel, Max Benson]
<?xml version="1.0" encoding="Windows-1250"?>
<people>
    <person>
        <first>Prof. Ambroy</first>
        <last>Kleks</last>
    </person>
    <person>
        <first>Alojzy</first>
        <last>Bbel</last>
    </person>
    <person>
        <first>Max</first>
        <last>Benson</last>
    </person>
</people>
*///:~
