//: typeinfo/toys/ToyTest.java
// Testowanie klasy Class.
package typeinfo.toys;
import static net.mindview.util.Print.*;

interface HasBatteries {}
interface Waterproof {}
interface Shoots {}

class Toy {
  // Wykomentowanie poniszego konstruktora domylnego
  // sprowokuje wyjtek NoSuchMethodError z (*1*)
  Toy() {}
  Toy(int i) {}
}

class FancyToy extends Toy
implements HasBatteries, Waterproof, Shoots {
  FancyToy() { super(1); }
}

public class ToyTest {
  static void printInfo(Class cc) {
    print("Nazwa klasy: " + cc.getName() +
      ", interfejs? [" + cc.isInterface() + "]");
    print("Nazwa prosta: " + cc.getSimpleName());
    print("Nazwa kanoniczna: " + cc.getCanonicalName());
  }
  public static void main(String[] args) {
    Class c = null;
    try {
      c = Class.forName("typeinfo.toys.FancyToy");
    } catch(ClassNotFoundException e) {
      print("Nie mona znale klasy FancyToy");
      System.exit(1);
    }
    printInfo(c);	
    for(Class face : c.getInterfaces())
      printInfo(face);
    Class up = c.getSuperclass();
    Object obj = null;
    try {
      // Wymaga konstruktora domylnego:
      obj = up.newInstance();
    } catch(InstantiationException e) {
      print("Nie mona utworzy egzemplarza");
      System.exit(1);
    } catch(IllegalAccessException e) {
      print("Brak dostpu");
      System.exit(1);
    }
    printInfo(obj.getClass());
  }
} /* Output:
Nazwa klasy: typeinfo.toys.FancyToy, interfejs? [false]
Nazwa prosta: FancyToy
Nazwa kanoniczna: typeinfo.toys.FancyToy
Nazwa klasy: typeinfo.toys.HasBatteries, interfejs? [true]
Nazwa prosta: HasBatteries
Nazwa kanoniczna: typeinfo.toys.HasBatteries
Nazwa klasy: typeinfo.toys.Waterproof, interfejs? [true]
Nazwa prosta: Waterproof
Nazwa kanoniczna: typeinfo.toys.Waterproof
Nazwa klasy: typeinfo.toys.Shoots, interfejs? [true]
Nazwa prosta: Shoots
Nazwa kanoniczna: typeinfo.toys.Shoots
Nazwa klasy: typeinfo.toys.Toy, interfejs? [false]
Nazwa prosta: Toy
Nazwa kanoniczna: typeinfo.toys.Toy
*///:~
