//: typeinfo/ClassInitialization.java
import java.util.*;

class Initable {
  static final int staticFinal = 47;
  static final int staticFinal2 =
    ClassInitialization.rand.nextInt(1000);
  static {
    System.out.println("Inicjalizacja klasy Initable");
  }
}

class Initable2 {
  static int staticNonFinal = 147;
  static {
    System.out.println("Inicjalizacja klasy Initable2");
  }
}

class Initable3 {
  static int staticNonFinal = 74;
  static {
    System.out.println("Inicjalizacja klasy Initable3");
  }
}

public class ClassInitialization {
  public static Random rand = new Random(47);
  public static void main(String[] args) throws Exception {
    Class initable = Initable.class;
    System.out.println("Po utworzeniu referencji Initable");
    // Nie prowokuje inicjalizacji:
    System.out.println(Initable.staticFinal);
    // Prowokuje inicjalizacj:
    System.out.println(Initable.staticFinal2);
    // Prowokuje inijcalizacj:
    System.out.println(Initable2.staticNonFinal);
    Class initable3 = Class.forName("Initable3");
    System.out.println("Po utworzeniu referencji Initable3");
    System.out.println(Initable3.staticNonFinal);
  }
} /* Output:
Po utworzeniu referencji Initable
47
Inicjalizacja klasy Initable
258
Inicjalizacja klasy Initable2
147
Inicjalizacja klasy Initable3
Po utworzeniu referencji Initable3
74
*///:~
