//: strings/Splitting.java
import java.util.*;

public class Splitting {
  public static String knights =
    "A gdy ju znajdziecie ywopot, musicie " +
    "ci najpotniejsze drzewo w tym lesie... za pomoc... " +
    "ledzia!";
  public static void split(String regex) {
    System.out.println(
      Arrays.toString(knights.split(regex)));
  }
  public static void main(String[] args) {
    split(" "); // Nie zawiera symboli wyraenia regularnego
    split("\\W+"); // Dopasowuje znaki spoza zbioru liter (a-z i A-Z) i cyfr
    split("e\\W+"); // Dopasowuje 'e' a za nim znaki spoza zbioru liter i cyfr
  }
} /* Output:
[A, gdy, ju, znajdziecie, ywopot,, musicie, ci, najpotniejsze, drzewo, w, tym, lesie..., za, pomoc..., ledzia!]
[A, gdy, ju, znajdziecie, ywop, ot, musicie, ci, najpot, niejsze, drzewo, w, tym, lesie, za, pomoc, ledzia]
[A gdy ju znajdzieci, ywopot, musici, ci najpotniejsz, drzewo w tym lesi, za pomoc... ledzia!]
*///:~
