//: strings/Receipt.java
import java.util.*;

public class Receipt {
  private double total = 0;
  private Formatter f = new Formatter(System.out);
  public void printTitle() {
    f.format("%-15s %5s %10s\n", "Towar", "Ilo", "Cena");
    f.format("%-15s %5s %10s\n", "-----", "-----", "----");
  }
  public void print(String name, int qty, double price) {
    f.format("%-15.15s %5d %10.2f\n", name, qty, price);
    total += price;
  }
  public void printTotal() {
    f.format("%-15s %5s %10.2f\n", "Podatek", "", total*0.22);
    f.format("%-15s %5s %10s\n", "", "", "-----");
    f.format("%-15s %5s %10.2f\n", "Razem", "",
      total * 1.22);
  }
  public static void main(String[] args) {
    Receipt receipt = new Receipt();
    receipt.printTitle();
    receipt.print("Magiczna fasolka", 4, 4.25);
    receipt.print("Ziarnko grochu", 3, 5.1);
    receipt.print("Kij Samobij", 1, 14.29);
    receipt.printTotal();
  }
} /* Output:
Towar           Ilo       Cena
-----           -----       ----
Magiczna fasolk     4       4,25
Ziarnko grochu      3       5,10
Kij Samobij         1      14,29
Podatek                     5,20
                           -----
Razem                      28,84
*///:~
