//: reusing/PlaceSetting.java
// czenie kompozycji i dziedziczenia.
import static net.mindview.util.Print.*;

class Plate {
  Plate(int i) {
    print("Konstruktor klasy Plate");
  }
}

class DinnerPlate extends Plate {
  DinnerPlate(int i) {
    super(i);
    print("Konstruktor klasy DinnerPlate");
  }
}	

class Utensil {
  Utensil(int i) {
    print("Konstruktor klasy Utensil");
  }
}

class Spoon extends Utensil {
  Spoon(int i) {
    super(i);
    print("Konstruktor klasy Spoon");
  }
}

class Fork extends Utensil {
  Fork(int i) {
    super(i);
    print("Konstruktor klasy Fork");
  }
}	

class Knife extends Utensil {
  Knife(int i) {
    super(i);
    print("Konstruktor klasy Knife");
  }
}

// Kulturalny sposb na wykonanie czego:
class Custom {
  Custom(int i) {
    print("Konstruktor klasy Custom");
  }
}	

public class PlaceSetting extends Custom {
  private Spoon sp;
  private Fork frk;
  private Knife kn;
  private DinnerPlate pl;
  public PlaceSetting(int i) {
    super(i + 1);
    sp = new Spoon(i + 2);
    frk = new Fork(i + 3);
    kn = new Knife(i + 4);
    pl = new DinnerPlate(i + 5);
    print("Konstruktor klasy PlaceSetting");
  }
  public static void main(String[] args) {
    PlaceSetting x = new PlaceSetting(9);
  }
} /* Output:
Konstruktor klasy Custom
Konstruktor klasy Utensil
Konstruktor klasy Spoon
Konstruktor klasy Utensil
Konstruktor klasy Fork
Konstruktor klasy Utensil
Konstruktor klasy Knife
Konstruktor klasy Plate
Konstruktor klasy DinnerPlate
Konstruktor klasy PlaceSetting
*///:~
