//: reusing/FinalOverridingIllusion.java
// Wydaje si, e mona przesoni metod
// prywatn albo prywatn finaln.
import static net.mindview.util.Print.*;

class WithFinals {
  // Identyczna z metod jedynie prywatn:
  private final void f() { print("WithFinals.f()"); }
  // Automatycznie rwnie finalna:
  private void g() { print("WithFinals.g()"); }
}

class OverridingPrivate extends WithFinals {
  private final void f() {
    print("OverridingPrivate.f()");
  }
  private void g() {
    print("OverridingPrivate.g()");
  }
}

class OverridingPrivate2 extends OverridingPrivate {
  public final void f() {
    print("OverridingPrivate2.f()");
  }
  public void g() {
    print("OverridingPrivate2.g()");
  }
}

public class FinalOverridingIllusion {
  public static void main(String[] args) {
    OverridingPrivate2 op2 = new OverridingPrivate2();
    op2.f();
    op2.g();
    // Mona rzutowa w gr:
    OverridingPrivate op = op2;
    // Ale nie mona wywoa metod:
    //! op.f();
    //! op.g();
    // To samo tutaj:
    WithFinals wf = op2;
    //! wf.f();
    //! wf.g();
  }
} /* Output:
OverridingPrivate2.f()
OverridingPrivate2.g()
*///:~
