//: reusing/FinalArguments.java
// Sowo "final" przy argumentach metod.

class Gizmo {
  public void spin() {}
}

public class FinalArguments {
  void with(final Gizmo g) {
    //! g = new Gizmo(); // Niedozwolone -- g jest argumentem finalnym
  }
  void without(Gizmo g) {
    g = new Gizmo(); // W porzdku -- g nie jest argumentem finalnym
    g.spin();
  }
  // void f(final int i) { i++; } // Nie mona zmienia
  // Finalny argument elementarny mona tylko odczytywa:
  int g(final int i) { return i + 1; }
  public static void main(String[] args) {
    FinalArguments bf = new FinalArguments();
    bf.without(null);
    bf.with(null);
  }
} ///:~
