//: polymorphism/ReferenceCounting.java
// Sprztanie wsplnych obiektw skadowych
import static net.mindview.util.Print.*;

class Shared {
  private int refcount = 0;
  private static long counter = 0;
  private final long id = counter++;
  public Shared() {
    print("Tworzenie " + this);
  }
  public void addRef() { refcount++; }
  protected void dispose() {
    if(--refcount == 0)
      print("Usuwanie " + this);
  }
  public String toString() { return "Shared " + id; }
}

class Composing {
  private Shared shared;
  private static long counter = 0;
  private final long id = counter++;
  public Composing(Shared shared) {
    print("Tworzenie " + this);
    this.shared = shared;
    this.shared.addRef();
  }
  protected void dispose() {
    print("Usuwanie " + this);
    shared.dispose();
  }
  public String toString() { return "Composing " + id; }
}

public class ReferenceCounting {
  public static void main(String[] args) {
    Shared shared = new Shared();
    Composing[] composing = { new Composing(shared),
      new Composing(shared), new Composing(shared),
      new Composing(shared), new Composing(shared) };
    for(Composing c : composing)
      c.dispose();
  }
} /* Output:
Tworzenie Shared 0
Tworzenie Composing 0
Tworzenie Composing 1
Tworzenie Composing 2
Tworzenie Composing 3
Tworzenie Composing 4
Usuwanie Composing 0
Usuwanie Composing 1
Usuwanie Composing 2
Usuwanie Composing 3
Usuwanie Composing 4
Usuwanie Shared 0
*///:~
