//: net/mindview/util/OSExecute.java
// Uruchomienie polecenia zewntrznego
// i przekazanie wyjcia na konsol.
package net.mindview.util;
import java.io.*;

public class OSExecute {
  public static void command(String command) {
    boolean err = false;
    try {
      Process process =
        new ProcessBuilder(command.split(" ")).start();
      BufferedReader results = new BufferedReader(
        new InputStreamReader(process.getInputStream()));
      String s;
      while((s = results.readLine())!= null)
        System.out.println(s);
      BufferedReader errors = new BufferedReader(
        new InputStreamReader(process.getErrorStream()));
      // Bdy bd sygnalizowane wypisaniem komunikatw i zwrceniem
      // wartoci niezerowej do procesu wywoujcego:
      while((s = errors.readLine())!= null) {
        System.err.println(s);
        err = true;
      }
    } catch(Exception e) {
      // Dla Windows 2000, ktry zrzuca wyjtek dla
      // domylnego interpretera polece:
      if(!command.startsWith("CMD /C"))
        command("CMD /C " + command);
      else
        throw new RuntimeException(e);
    }
    if(err)
      throw new OSExecuteException("Bdy przy uruchamianiu " +
        command);
  }
} ///:~
