//: net/mindview/atunit/AtUnit.java
// Infrastruktura testw moduw na bazie adnotacji.
// {RunByHand}
package net.mindview.atunit;
import java.lang.reflect.*;
import java.io.*;
import java.util.*;
import net.mindview.util.*;
import static net.mindview.util.Print.*;

public class AtUnit implements ProcessFiles.Strategy {
  static Class<?> testClass;
  static List<String> failedTests= new ArrayList<String>();
  static long testsRun = 0;
  static long failures = 0;
  public static void main(String[] args) throws Exception {
    ClassLoader.getSystemClassLoader()
      .setDefaultAssertionStatus(true); // Wczenie asercji
    new ProcessFiles(new AtUnit(), "class").start(args);
    if(failures == 0)
      print("OK (" + testsRun + " test(y)(w))");
    else {
      print("(" + testsRun + " test(y)(w))");
      print("\n>>> " + failures + " NIEUDAN" +
        (failures > 1 ? "E(-NYCH)" : "Y") + " <<<");
      for(String failed : failedTests)
        print("  " + failed);
    }
  }
  public void process(File cFile) {
    try {
      String cName = ClassNameFinder.thisClass(
        BinaryFile.read(cFile));
      if(!cName.contains("."))
        return; // Ignorowanie klas spoza pakietw
      testClass = Class.forName(cName);
    } catch(Exception e) {
      throw new RuntimeException(e);
    }
    TestMethods testMethods = new TestMethods();
    Method creator = null;
    Method cleanup = null;
    for(Method m : testClass.getDeclaredMethods()) {
      testMethods.addIfTestMethod(m);
      if(creator == null)
        creator = checkForCreatorMethod(m);
      if(cleanup == null)
        cleanup = checkForCleanupMethod(m);
    }
    if(testMethods.size() > 0) {
      if(creator == null)
        try {
          if(!Modifier.isPublic(testClass
             .getDeclaredConstructor().getModifiers())) {
            print("Bd: " + testClass +
              " konstruktor domylny musi by publiczny");
            System.exit(1);
          }
        } catch(NoSuchMethodException e) {
          // Wystarczy syntetyzowany konstruktor domylny
        }
      print(testClass.getName());
    }
    for(Method m : testMethods) {
      printnb("  . " + m.getName() + " ");
      try {
        Object testObject = createTestObject(creator);
        boolean success = false;
        try {
          if(m.getReturnType().equals(boolean.class))
            success = (Boolean)m.invoke(testObject);
          else {
            m.invoke(testObject);
            success = true; // Jeli wszystkie asercje byy spenione
          }
        } catch(InvocationTargetException e) {
          // Waciwy wyjtek tkwi w e:
          print(e.getCause());
        }
        print(success ? "" : "(nieudany)");
        testsRun++;
        if(!success) {
          failures++;
          failedTests.add(testClass.getName() +
            ": " + m.getName());
        }
        if(cleanup != null)
          cleanup.invoke(testObject, testObject);
      } catch(Exception e) {
        throw new RuntimeException(e);
      }
    }
  }
  static class TestMethods extends ArrayList<Method> {
    void addIfTestMethod(Method m) {
      if(m.getAnnotation(Test.class) == null)
        return;
      if(!(m.getReturnType().equals(boolean.class) ||
          m.getReturnType().equals(void.class)))
        throw new RuntimeException("Metoda @Test " +
          "musi zwraca void albo boolean");
      m.setAccessible(true); // Dla prywatnych
      add(m);
    }
  }
  private static Method checkForCreatorMethod(Method m) {
    if(m.getAnnotation(TestObjectCreate.class) == null)
      return null;
    if(!m.getReturnType().equals(testClass))
      throw new RuntimeException("Metoda @TestObjectCreate " +
        "musi zwraca egzemplarz testowanej klasy.");
    if((m.getModifiers() &
         java.lang.reflect.Modifier.STATIC) < 1)
      throw new RuntimeException("Metoda @TestObjectCreate " +
        "musi by statyczna.");
    m.setAccessible(true);
    return m;
  }
  private static Method checkForCleanupMethod(Method m) {
    if(m.getAnnotation(TestObjectCleanup.class) == null)
      return null;
    if(!m.getReturnType().equals(void.class))
      throw new RuntimeException("Metoda @TestObjectCleanup " +
        "nie moe zwraca wartoci.");
    if((m.getModifiers() &
        java.lang.reflect.Modifier.STATIC) < 1)
      throw new RuntimeException("Metoda @TestObjectCleanup " +
        "musi by statyczna.");
    if(m.getParameterTypes().length == 0 ||
       m.getParameterTypes()[0] != testClass)
      throw new RuntimeException("Metoda @TestObjectCleanup " +
        "musi przyjmowa argument testowanego typu.");
    m.setAccessible(true);
    return m;
  }
  private static Object createTestObject(Method creator) {
    if(creator != null) {
      try {
        return creator.invoke(testClass);
      } catch(Exception e) {
        throw new RuntimeException("Nie mona uruchomi metody " +
          "@TestObject (kreatora).");
      }
    } else { // uycie konstruktora domylnego:
      try {
        return testClass.newInstance();
      } catch(Exception e) {
        throw new RuntimeException("Nie mona utworzy " +
          "obiektu testowego. Sprbuj metody @TestObject.");
      }
    }
  }
} ///:~
