//: io/GetData.java
// Wyuskiwanie rnych reprezentacji z bufora ByteBuffer
import java.nio.*;
import static net.mindview.util.Print.*;

public class GetData {
  private static final int BSIZE = 1024;
  public static void main(String[] args) {
    ByteBuffer bb = ByteBuffer.allocate(BSIZE);
    // Przydzia automatycznie zeruje bufor ByteBuffer:
    int i = 0;
    while(i++ < bb.limit())
      if(bb.get() != 0)
        print("niezerowa");
    print("i = " + i);
    bb.rewind();
    // Zapisanie i odczytanie tablicy znakw:
    bb.asCharBuffer().put("Jak leci?");
    char c;
    while((c = bb.getChar()) != 0)
      printnb(c + " ");
    print();
    bb.rewind();
    // Zapisanie i odczytanie wartoci typu short:
    bb.asShortBuffer().put((short)471142);
    print(bb.getShort());
    bb.rewind();
    // Zapisanie i odczytanie wartoci typu int:
    bb.asIntBuffer().put(99471142);
    print(bb.getInt());
    bb.rewind();
    // Zapisanie i odczytanie wartoci typu long:
    bb.asLongBuffer().put(99471142);
    print(bb.getLong());
    bb.rewind();
    // Zapisanie i odczytanie wartoci typu float:
    bb.asFloatBuffer().put(99471142);
    print(bb.getFloat());
    bb.rewind();
    // Zapisanie i odczytanie wartoci typu double:
    bb.asDoubleBuffer().put(99471142);
    print(bb.getDouble());
    bb.rewind();
  }
} /* Output:
i = 1025
J a k   l e c i ? 
12390
99471142
99471142
9.9471144E7
9.9471142E7
*///:~
