//: io/BufferToText.java
// Konwersja tekstu do i z typu ByteBuffer
import java.nio.*;
import java.nio.channels.*;
import java.nio.charset.*;
import java.io.*;

public class BufferToText {
  private static final int BSIZE = 1024;
  public static void main(String[] args) throws Exception {
    FileChannel fc =
      new FileOutputStream("data2.txt").getChannel();
    fc.write(ByteBuffer.wrap("Jaki tekst".getBytes()));
    fc.close();
    fc = new FileInputStream("data2.txt").getChannel();
    ByteBuffer buff = ByteBuffer.allocate(BSIZE);
    fc.read(buff);
    buff.flip();
    // Nie dziaa:
    System.out.println(buff.asCharBuffer());
    // Dekodowanie przy uyciu domylnego zestawu
    // znakw danego systemu operacyjnego:
    buff.rewind();
    String encoding = System.getProperty("file.encoding");
    System.out.println("Dekodowane jako " + encoding + ": "
      + Charset.forName(encoding).decode(buff));
    // Moglibymy te zakodowa co, co da si wypisa:
    fc = new FileOutputStream("data2.txt").getChannel();
    fc.write(ByteBuffer.wrap(
      "Jaki tekst".getBytes("UTF-16BE")));
    fc.close();
    // I ponownie sprbowa odczytu:
    fc = new FileInputStream("data2.txt").getChannel();
    buff.clear();
    fc.read(buff);
    buff.flip();
    System.out.println(buff.asCharBuffer());
    // Uycie bufora CharBuffer przy zapisie:
    fc = new FileOutputStream("data2.txt").getChannel();
    buff = ByteBuffer.allocate(24); // Wicej, ni trzeba
    buff.asCharBuffer().put("Jaki tekst");
    fc.write(buff);
    fc.close();
    // Wczytanie i wypisanie:
    fc = new FileInputStream("data2.txt").getChannel();
    buff.clear();
    fc.read(buff);
    buff.flip();
    System.out.println(buff.asCharBuffer());
  }
} /* Output:
?????
Dekodowane jako Cp1250: Jaki tekst
Jaki tekst
Jaki tekst 
*///:~
