//: io/Blips.java
// Proste zastosowanie interfejsu Externalizable i maa puapka.
import java.io.*;
import static net.mindview.util.Print.*;

class Blip1 implements Externalizable {
  public Blip1() {
    print("Konstruktor Blip1");
  }
  public void writeExternal(ObjectOutput out)
      throws IOException {
    print("Blip1.writeExternal");
  }
  public void readExternal(ObjectInput in)
     throws IOException, ClassNotFoundException {
    print("Blip1.readExternal");
  }
}

class Blip2 implements Externalizable {
  Blip2() {
    print("Konstruktor Blip2");
  }
  public void writeExternal(ObjectOutput out)
      throws IOException {
    print("Blip2.writeExternal");
  }
  public void readExternal(ObjectInput in)
     throws IOException, ClassNotFoundException {
    print("Blip2.readExternal");
  }
}

public class Blips {
  public static void main(String[] args)
  throws IOException, ClassNotFoundException {
    print("Konstrukcja obiektw:");
    Blip1 b1 = new Blip1();
    Blip2 b2 = new Blip2();
    ObjectOutputStream o = new ObjectOutputStream(
      new FileOutputStream("Blips.out"));
    print("Zapis obiektw:");
    o.writeObject(b1);
    o.writeObject(b2);
    o.close();
    // A teraz odtworzenie:
    ObjectInputStream in = new ObjectInputStream(
      new FileInputStream("Blips.out"));
    print("Odtwarzanie b1:");
    b1 = (Blip1)in.readObject();
    // OHO! Wyjtek:
//! print("Odtwarzanie b2:");
//! b2 = (Blip2)in.readObject();
  }
} /* Output:
Konstrukcja obiektw:
Konstruktor Blip1
Konstruktor Blip2
Zapis obiektw:
Blip1.writeExternal
Blip2.writeExternal
Odtwarzanie b1:
Konstruktor Blip1
Blip1.readExternal
*///:~
