//: innerclasses/GreenhouseControls.java
// Konkretne wdroenie systemu sterowania w postaci pojedynczej
// klasy. Klasy wewntrzne pozwalaj na hermetyzowanie rnych
// funkcjonalnoci dla poszczeglnych typw zdarze.
import innerclasses.controller.*;

public class GreenhouseControls extends Controller {
  private boolean light = false;
  public class LightOn extends Event {
    public LightOn(long delayTime) { super(delayTime); }
    public void action() {
      // Tutaj kod sterowania sprztem, ktry
      // fizycznie wczy wiata.
      light = true;
    }
    public String toString() { return "wiata wczone"; }
  }	
  public class LightOff extends Event {
    public LightOff(long delayTime) { super(delayTime); }
    public void action() {
      // Tutaj kod sterowania sprztem, ktry
      // fizycznie wyczy wiata.
      light = false;
    }
    public String toString() { return "wiata wyczone"; }
  }
  private boolean water = false;
  public class WaterOn extends Event {
    public WaterOn(long delayTime) { super(delayTime); }
    public void action() {
      // Tu kod sterowania sprztem.
      water = true;
    }
    public String toString() {
      return "Obieg wody w szklarni wczony";
    }
  }	
  public class WaterOff extends Event {
    public WaterOff(long delayTime) { super(delayTime); }
    public void action() {
      // Tu kod sterowania sprztem.
      water = false;
    }
    public String toString() {
      return "Obieg wody w szklarni wyczony";
    }
  }
  private String thermostat = "Dzie";	
  public class ThermostatNight extends Event {
    public ThermostatNight(long delayTime) {
      super(delayTime);
    }
    public void action() {
      // Tu kod sterowania sprztem.
      thermostat = "Noc";
    }
    public String toString() {
      return "Termostat przeczony na ustawienie nocne";
    }
  }	
  public class ThermostatDay extends Event {
    public ThermostatDay(long delayTime) {
      super(delayTime);
    }
    public void action() {
      // Tu kod sterowania sprztem.
      thermostat = "Dzie";
    }
    public String toString() {
      return "Termostat przeczony na ustawienie dzienne";
    }
  }
  // Przykad metody action(), uzupeniajcej
  // list zdarze o nowy obiekt zdarzenia
  public class Bell extends Event {
    public Bell(long delayTime) { super(delayTime); }
    public void action() {
      addEvent(new Bell(delayTime));
    }
    public String toString() { return "Dzy!"; }
  }	
  public class Restart extends Event {
    private Event[] eventList;
    public Restart(long delayTime, Event[] eventList) {
      super(delayTime);
      this.eventList = eventList;
      for(Event e : eventList)
        addEvent(e);
    }
    public void action() {
      for(Event e : eventList) {
        e.start(); // Ponowne wyzwolenie kadego zdarzenia
        addEvent(e);
      }
      start(); // Ponowne wyzwolenie danego zdarzenia
      addEvent(this);
    }
    public String toString() {
      return "Restart systemu";
    }
  }	
  public static class Terminate extends Event {
    public Terminate(long delayTime) { super(delayTime); }
    public void action() { System.exit(0); }
    public String toString() { return "Koniec";  }
  }
} ///:~
