//: innerclasses/AnonymousConstructor.java
// Konstruktor dla anonimowej klasy wewntrznej.
import static net.mindview.util.Print.*;

abstract class Base {
  public Base(int i) {
    print("Konstruktor bazowy, i = " + i);
  }
  public abstract void f();
}	

public class AnonymousConstructor {
  public static Base getBase(int i) {
    return new Base(i) {
      { print("Wewntrz inicjalizatora egzemplarza"); }
      public void f() {
        print("W metodzie f() klasy anonimowej");
      }
    };
  }
  public static void main(String[] args) {
    Base base = getBase(47);
    base.f();
  }
} /* Output:
Konstruktor bazowy, i = 47
Wewntrz inicjalizatora egzemplarza
W metodzie f() klasy anonimowej
*///:~
