//: holding/LinkedListFeatures.java
import typeinfo.pets.*;
import java.util.*;
import static net.mindview.util.Print.*;

public class LinkedListFeatures {
  public static void main(String[] args) {
    LinkedList<Pet> pets =
      new LinkedList<Pet>(Pets.arrayList(5));
    print(pets);
    // Identyczne:
    print("pets.getFirst(): " + pets.getFirst());
    print("pets.element(): " + pets.element());
    // Rni si jedynie zachowaniem w obliczu braku elementw:
    print("pets.peek(): " + pets.peek());
    // Identyczne; usuwaj i zwracaj pierwszy element listy:
    print("pets.remove(): " + pets.remove());
    print("pets.removeFirst(): " + pets.removeFirst());
    // Rni si jedynie zachowaniem w obliczu braku elementw::
    print("pets.poll(): " + pets.poll());
    print(pets);
    pets.addFirst(new Rat());
    print("Po addFirst(): " + pets);
    pets.offer(Pets.randomPet());
    print("Po offer(): " + pets);
    pets.add(Pets.randomPet());
    print("Po add(): " + pets);
    pets.addLast(new Hamster());
    print("Po addLast(): " + pets);
    print("pets.removeLast(): " + pets.removeLast());
  }
} /* Output:
[Rat, Manx, Cymric, Mutt, Pug]
pets.getFirst(): Rat
pets.element(): Rat
pets.peek(): Rat
pets.remove(): Rat
pets.removeFirst(): Manx
pets.poll(): Cymric
[Mutt, Pug]
Po addFirst(): [Rat, Mutt, Pug]
Po offer(): [Rat, Mutt, Pug, Cymric]
Po add(): [Rat, Mutt, Pug, Cymric, Pug]
Po addLast(): [Rat, Mutt, Pug, Cymric, Pug, Hamster]
pets.removeLast(): Hamster
*///:~
