//: holding/AdapterMethodIdiom.java
// Idiom "metoda-adapter" ppzwala stosowanie foreach
// z dodatkowymi rodzajami iteratorw.
import java.util.*;

class ReversibleArrayList<T> extends ArrayList<T> {
  public ReversibleArrayList(Collection<T> c) { super(c); }
  public Iterable<T> reversed() {
    return new Iterable<T>() {
      public Iterator<T> iterator() {
        return new Iterator<T>() {
          int current = size() - 1;
          public boolean hasNext() { return current > -1; }
          public T next() { return get(current--); }
          public void remove() { // Niezaimplementowana
            throw new UnsupportedOperationException();
          }
        };
      }
    };
  }
}	

public class AdapterMethodIdiom {
  public static void main(String[] args) {
    ReversibleArrayList<String> ral =
      new ReversibleArrayList<String>(
        Arrays.asList("By albo nie by".split(" ")));
    // Pozyskanie zwykego iteratora wywoaniem iterator():
    for(String s : ral)
      System.out.print(s + " ");
    System.out.println();
    // A teraz iteratora alternatywnego
    for(String s : ral.reversed())
      System.out.print(s + " ");
  }
} /* Output:
By albo nie by
by nie albo By
*///:~
