//: gui/SimpleMenus.java
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import static net.mindview.util.SwingConsole.*;

public class SimpleMenus extends JFrame {
  private JTextField t = new JTextField(15);
  private ActionListener al = new ActionListener() {
    public void actionPerformed(ActionEvent e) {
      t.setText(((JMenuItem)e.getSource()).getText());
    }
  };
  private JMenu[] menus = {
    new JMenu("Ene"), new JMenu("Due"),
    new JMenu("Rabe")
  };
  private JMenuItem[] items = {
    new JMenuItem("Zapa"), new JMenuItem("Bocian"),
    new JMenuItem("ab"),  new JMenuItem("A"),
    new JMenuItem("aba"), new JMenuItem("Chiczyka"),
    new JMenuItem("Co"), new JMenuItem("Z tego"),
    new JMenuItem("Wynika")
  };
  public SimpleMenus() {
    for(int i = 0; i < items.length; i++) {
      items[i].addActionListener(al);
      menus[i % 3].add(items[i]);
    }
    JMenuBar mb = new JMenuBar();
    for(JMenu jm : menus)
      mb.add(jm);
    setJMenuBar(mb);
    setLayout(new FlowLayout());
    add(t);
  }
  public static void main(String[] args) {
    run(new SimpleMenus(), 200, 150);
  }
} ///:~
