//: gui/MessageBoxes.java
// Moliwoci kontrolek JOptionPane.
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import static net.mindview.util.SwingConsole.*;

public class MessageBoxes extends JFrame {
  private JButton[] b = {
    new JButton("Uwaga"), new JButton("Tak-Nie"),
    new JButton("Kolor"), new JButton("Wejcie"),
    new JButton("3-wartociowe")
  };
  private JTextField txt = new JTextField(15);
  private ActionListener al = new ActionListener() {
    public void actionPerformed(ActionEvent e) {
      String id = ((JButton)e.getSource()).getText();
      if(id.equals("Uwaga"))
        JOptionPane.showMessageDialog(null,
          "Masz robaka we wosach!", "Hej!",
          JOptionPane.ERROR_MESSAGE);
      else if(id.equals("Tak-Nie"))
        JOptionPane.showConfirmDialog(null,
          "albo nie", "wybierz tak",
          JOptionPane.YES_NO_OPTION);
      else if(id.equals("Kolor")) {
        Object[] options = { "Czerwony", "Zielony" };
        int sel = JOptionPane.showOptionDialog(
          null, "Wybierz kolor!", "Ostrzeenie",
          JOptionPane.DEFAULT_OPTION,
          JOptionPane.WARNING_MESSAGE, null,
          options, options[0]);
        if(sel != JOptionPane.CLOSED_OPTION)
          txt.setText("Wybrany kolor: " + options[sel]);
      } else if(id.equals("Input")) {
        String val = JOptionPane.showInputDialog(
            "Ile widzisz palcw?");
        txt.setText(val);
      } else if(id.equals("3-wartociowe")) {
        Object[] selections = {"Pierwszy", "Drugi", "Trzeci"};
        Object val = JOptionPane.showInputDialog(
          null, "Wybierz jedno", "Wejcie",
          JOptionPane.INFORMATION_MESSAGE,
          null, selections, selections[0]);
        if(val != null)
          txt.setText(val.toString());
      }
    }
  };
  public MessageBoxes() {
    setLayout(new FlowLayout());
    for(int i = 0; i < b.length; i++) {
      b[i].addActionListener(al);
      add(b[i]);
    }
    add(txt);
  }
  public static void main(String[] args) {
    run(new MessageBoxes(), 200, 200);
  }
} ///:~
