//: generics/Wildcards.java
// Badanie znaczenia symboli wieloznacznych w uoglnieniach.

public class Wildcards {
   // Argument goego typu:
  static void rawArgs(Holder holder, Object arg) {
    // holder.set(arg); // Ostrzeenie:
    //   Niesprawdzane wywoanie set(T) jako metody
    //   goego typu Holder
    // holder.set(new Wildcards()); // To samo

    // Tak nie mona; nie znamy adnego 'T':
    // T t = holder.get();

    // OK, ale z utrat informacji o typie:
    Object obj = holder.get();
  }	
  // Jak w rawArgs(), ale z bdami zamiast ostrzeen:
  static void unboundedArg(Holder<?> holder, Object arg) {
    // holder.set(arg); // Bd
    //   (set(capture of ?) in Holder<capture of ?>
    //   cannot be applied to (Object))
    // holder.set(new Wildcards()); // Taki sam bd

    // Tak nie mona; nie znamy adnego 'T':
    // T t = holder.get();

    // OK, ale z utrat informacji o typie:
    Object obj = holder.get();
  }	
  static <T> T exact1(Holder<T> holder) {
    T t = holder.get();
    return t;
  }
  static <T> T exact2(Holder<T> holder, T arg) {
    holder.set(arg);
    T t = holder.get();
    return t;
  }
  static <T>
  T wildSubtype(Holder<? extends T> holder, T arg) {
    // holder.set(arg); // Bd
    //   (set(capture of ? extends T) in
    //   Holder<capture of ? extends T>
    //   cannot be applied to (T))
    T t = holder.get();
    return t;
  }	
  static <T>
  void wildSupertype(Holder<? super T> holder, T arg) {
    holder.set(arg);
    // T t = holder.get();  // Bd
    //   (ncompatible types: found Object, required T)

    // OK, ale z utrat informacji o typie:
    Object obj = holder.get();
  }
  public static void main(String[] args) {
    Holder raw = new Holder<Long>();
    // Albo tak:
    raw = new Holder();
    Holder<Long> qualified = new Holder<Long>();
    Holder<?> unbounded = new Holder<Long>();
    Holder<? extends Long> bounded = new Holder<Long>();
    Long lng = 1L;

    rawArgs(raw, lng);
    rawArgs(qualified, lng);
    rawArgs(unbounded, lng);
    rawArgs(bounded, lng);
	
    unboundedArg(raw, lng);
    unboundedArg(qualified, lng);
    unboundedArg(unbounded, lng);
    unboundedArg(bounded, lng);

    // Object r1 = exact1(raw); // Ostrzeenia
    //   (Unchecked conversion from Holder to Holder<T>,
    //   Unchecked method invocation: exact1(Holder<T>)
    //   is applied to (Holder))
    Long r2 = exact1(qualified);
    Object r3 = exact1(unbounded); // Musi zwraca Object
    Long r4 = exact1(bounded);
	
    // Long r5 = exact2(raw, lng); // Ostrzeenia
    //   (Unchecked conversion from Holder to Holder<Long>
    //   Unchecked method invocation: exact2(Holder<T>,T)
    //   is applied to (Holder,Long))
    Long r6 = exact2(qualified, lng);
    // Long r7 = exact2(unbounded, lng); // Bd
    //   (exact2(Holder<T>,T) cannot be applied to
    //   (Holder<capture of ?>,Long))
    // Long r8 = exact2(bounded, lng); // Bd
    //   (exact2(Holder<T>,T) cannot be applied
    //   to (Holder<capture of ? extends Long>,Long))
	
    // Long r9 = wildSubtype(raw, lng); // Ostrzeenia
    //   (Unchecked conversion from Holder
    //   to Holder<? extends Long>
    //   Unchecked method invocation:
    //   wildSubtype(Holder<? extends T>,T) is
    //   applied to (Holder,Long))
    Long r10 = wildSubtype(qualified, lng);
    // OK, ale moe zwrci jedynie Object:
    Object r11 = wildSubtype(unbounded, lng);
    Long r12 = wildSubtype(bounded, lng);
	
    // wildSupertype(raw, lng); // Ostrzeenia
    //   (Unchecked conversion from Holder
    //   to Holder<? super Long>
    //   Unchecked method invocation:
    //   wildSupertype(Holder<? super T>,T)
    //   is applied to (Holder,Long))
    wildSupertype(qualified, lng);
    // wildSupertype(unbounded, lng); // Bd
    //   (wildSupertype(Holder<? super T>,T) cannot be
    //   applied to (Holder<capture of ?>,Long))
    // wildSupertype(bounded, lng); // Bd
    //   (wildSupertype(Holder<? super T>,T) cannot be
    //  applied to (Holder<capture of ? extends Long>,Long))
  }
} ///:~
