//: generics/SelfBounding.java

class SelfBounded<T extends SelfBounded<T>> {
  T element;
  SelfBounded<T> set(T arg) {
    element = arg;
    return this;
  }
  T get() { return element; }
}

class A extends SelfBounded<A> {}
class B extends SelfBounded<A> {} // Te dobrze

class C extends SelfBounded<C> {
  C setAndGet(C arg) { set(arg); return get(); }
}	

class D {}
// Nie mona tak:
// class E extends SelfBounded<D> {}
// Bd kompilacji: parametr typowy D spoza ramy

// Niestety, mona te tak, wic nie mona narzuci idiomu:
class F extends SelfBounded {}

public class SelfBounding {
  public static void main(String[] args) {
    A a = new A();
    a.set(new A());
    a = a.set(new A()).get();
    a = a.get();
    C c = new C();
    c = c.setAndGet(new C());
  }
} ///:~
