//: generics/BankTeller.java
// Bardzo prosta symulacja okienka kasowego.
import java.util.*;
import net.mindview.util.*;

class Customer {
  private static long counter = 1;
  private final long id = counter++;
  private Customer() {}
  public String toString() { return "Klient " + id; }
  // Metoda tworzca obiekty klasy Generator:
  public static Generator<Customer> generator() {
    return new Generator<Customer>() {
      public Customer next() { return new Customer(); }
    };
  }
}	

class Teller {
  private static long counter = 1;
  private final long id = counter++;
  private Teller() {}
  public String toString() { return "Kasjer " + id; }
  // Pojedynczy obiekt generatora Generator:
  public static Generator<Teller> generator =
    new Generator<Teller>() {
      public Teller next() { return new Teller(); }
    };
}	

public class BankTeller {
  public static void serve(Teller t, Customer c) {
    System.out.println(t + " obsuguje klienta " + c);
  }
  public static void main(String[] args) {
    Random rand = new Random(47);
    Queue<Customer> line = new LinkedList<Customer>();
    Generators.fill(line, Customer.generator(), 15);
    List<Teller> tellers = new ArrayList<Teller>();
    Generators.fill(tellers, Teller.generator, 4);
    for(Customer c : line)
      serve(tellers.get(rand.nextInt(tellers.size())), c);
  }	
} /* Output:
Kasjer 3 obsuguje klienta Klient 1
Kasjer 2 obsuguje klienta Klient 2
Kasjer 3 obsuguje klienta Klient 3
Kasjer 1 obsuguje klienta Klient 4
Kasjer 1 obsuguje klienta Klient 5
Kasjer 3 obsuguje klienta Klient 6
Kasjer 1 obsuguje klienta Klient 7
Kasjer 2 obsuguje klienta Klient 8
Kasjer 3 obsuguje klienta Klient 9
Kasjer 3 obsuguje klienta Klient 10
Kasjer 2 obsuguje klienta Klient 11
Kasjer 4 obsuguje klienta Klient 12
Kasjer 2 obsuguje klienta Klient 13
Kasjer 1 obsuguje klienta Klient 14
Kasjer 1 obsuguje klienta Klient 15
*///:~
