//: exceptions/Rethrowing.java
// Demonstracja metody fillInStackTrace()

public class Rethrowing {
  public static void f() throws Exception {
    System.out.println("wyjtek poczty w f()");
    throw new Exception("wyrzucony z f()");
  }
  public static void g() throws Exception {
    try {
      f();
    } catch(Exception e) {
      System.out.println("W g(),e.printStackTrace()");
      e.printStackTrace(System.out);
      throw e;
    }
  }
  public static void h() throws Exception {
    try {
      f();
    } catch(Exception e) {
      System.out.println("W h(),e.printStackTrace()");
      e.printStackTrace(System.out);
      throw (Exception)e.fillInStackTrace();
    }
  }
  public static void main(String[] args) {
    try {
      g();
    } catch(Exception e) {
      System.out.println("Metoda main: printStackTrace()");
      e.printStackTrace(System.out);
    }
    try {
      h();
    } catch(Exception e) {
      System.out.println("Metoda main: printStackTrace()");
      e.printStackTrace(System.out);
    }
  }
} /* Output:
wyjtek poczty w f()
W g(),e.printStackTrace()
java.lang.Exception: wyrzucony z f()
        at Rethrowing.f(Rethrowing.java:7)
        at Rethrowing.g(Rethrowing.java:11)
        at Rethrowing.main(Rethrowing.java:29)
Metoda main: printStackTrace()
java.lang.Exception: wyrzucony z f()
        at Rethrowing.f(Rethrowing.java:7)
        at Rethrowing.g(Rethrowing.java:11)
        at Rethrowing.main(Rethrowing.java:29)
wyjtek poczty w f()
W h(),e.printStackTrace()
java.lang.Exception: wyrzucony z f()
        at Rethrowing.f(Rethrowing.java:7)
        at Rethrowing.h(Rethrowing.java:20)
        at Rethrowing.main(Rethrowing.java:35)
Metoda main: printStackTrace()
java.lang.Exception: wyrzucony z f()
        at Rethrowing.h(Rethrowing.java:24)
        at Rethrowing.main(Rethrowing.java:35)
*///:~
