//: enumerated/TrafficLight.java
// Typy wyliczeniowe w instrukcjach wyboru.
import static net.mindview.util.Print.*;

// Definicja typu wyliczeniowego:
enum Signal { ZIELONE, ӣTE, CZERWONE, }

public class TrafficLight {
  Signal color = Signal.CZERWONE;
  public void change() {
    switch(color) {
      // Zauwa, e w klauzulach case nie nie trzeba
      // stosowa zapisu Signal.CZERWONE itd.:
      case CZERWONE:  color = Signal.ZIELONE;
                      break;
      case ZIELONE:   color = Signal.ӣTE;
                      break;
      case ӣTE:     color = Signal.CZERWONE;
                      break;
    }
  }
  public String toString() {
    return "Sygnalizator nadaje wiato " + color;
  }
  public static void main(String[] args) {
    TrafficLight t = new TrafficLight();
    for(int i = 0; i < 7; i++) {
      print(t);
      t.change();
    }
  }
} /* Output:
Sygnalizator nadaje wiato CZERWONE
Sygnalizator nadaje wiato ZIELONE
Sygnalizator nadaje wiato ӣTE
Sygnalizator nadaje wiato CZERWONE
Sygnalizator nadaje wiato ZIELONE
Sygnalizator nadaje wiato ӣTE
Sygnalizator nadaje wiato CZERWONE
*///:~
