//: enumerated/RoShamBo2.java
// Przeczanie typu wyliczeniowego wedle innego typu wyliczeniowego.
package enumerated;
import static enumerated.Outcome.*;

public enum RoShamBo2 implements Competitor<RoShamBo2> {
  PAPER(DRAW, LOSE, WIN) {
    public String toString() { return "Papier"; }
  },
  SCISSORS(WIN, DRAW, LOSE) {
    public String toString() { return "Noyczki"; }
  },
  ROCK(LOSE, WIN, DRAW) {
    public String toString() { return "Kamie"; }
  };
  private Outcome vPAPER, vSCISSORS, vROCK;
  RoShamBo2(Outcome paper,Outcome scissors,Outcome rock) {
    this.vPAPER = paper;
    this.vSCISSORS = scissors;
    this.vROCK = rock;
  }	
  public Outcome compete(RoShamBo2 it) {
    switch(it) {
      default:
      case PAPER: return vPAPER;
      case SCISSORS: return vSCISSORS;
      case ROCK: return vROCK;
    }
  }
  public static void main(String[] args) {
    RoShamBo.play(RoShamBo2.class, 20);
  }
} /* Output:
Kamie kontra Kamie: REMIS
Noyczki kontra Kamie: PRZEGRANA
Noyczki kontra Kamie: PRZEGRANA
Noyczki kontra Kamie: PRZEGRANA
Papier kontra Noyczki: PRZEGRANA
Papier kontra Papier: REMIS
Papier kontra Noyczki: PRZEGRANA
Kamie kontra Noyczki: WYGRANA
Noyczki kontra Noyczki: REMIS
Kamie kontra Noyczki: WYGRANA
Noyczki kontra Papier: WYGRANA
Noyczki kontra Papier: WYGRANA
Kamie kontra Papier: PRZEGRANA
Kamie kontra Noyczki: WYGRANA
Noyczki kontra Kamie: PRZEGRANA
Papier kontra Noyczki: PRZEGRANA
Noyczki kontra Papier: WYGRANA
Noyczki kontra Papier: WYGRANA
Noyczki kontra Papier: WYGRANA
Noyczki kontra Papier: WYGRANA
*///:~
