//: enumerated/EnumMaps.java
// Podstawy stosowania klasy EnumMaps.
package enumerated;
import java.util.*;
import static enumerated.AlarmPoints.*;
import static net.mindview.util.Print.*;

interface Command { void action(); }

public class EnumMaps {
  public static void main(String[] args) {
    EnumMap<AlarmPoints,Command> em =
      new EnumMap<AlarmPoints,Command>(AlarmPoints.class);
    em.put(KITCHEN, new Command() {
      public void action() { print("Poar kuchni!"); }
    });
    em.put(BATHROOM, new Command() {
      public void action() { print("Alarm w azience!"); }
    });
    for(Map.Entry<AlarmPoints,Command> e : em.entrySet()) {
      printnb(e.getKey() + ": ");
      e.getValue().action();
    }
    try { // W przypadku braku wartoci dla danego klucza:
      em.get(UTILITY).action();
    } catch(Exception e) {
      print(e);
    }
  }
} /* Output:
BATHROOM: Alarm w azience!
KITCHEN: Poar kuchni!
java.lang.NullPointerException
*///:~
