//: containers/ToDoList.java
// Bardziej zaawansowane zastosowanie kolejki PriorityQueue.
import java.util.*;

class ToDoList extends PriorityQueue<ToDoList.ToDoItem> {
  static class ToDoItem implements Comparable<ToDoItem> {
    private char primary;
    private int secondary;
    private String item;
    public ToDoItem(String td, char pri, int sec) {
      primary = pri;
      secondary = sec;
      item = td;
    }
    public int compareTo(ToDoItem arg) {
      if(primary > arg.primary)
        return +1;
      if(primary == arg.primary)
        if(secondary > arg.secondary)
          return +1;
        else if(secondary == arg.secondary)
          return 0;
      return -1;
    }
    public String toString() {
      return Character.toString(primary) +
        secondary + ": " + item;
    }
  }
  public void add(String td, char pri, int sec) {
    super.add(new ToDoItem(td, pri, sec));
  }
  public static void main(String[] args) {
    ToDoList toDoList = new ToDoList();
    toDoList.add("Wynie mieci", 'C', 4);
    toDoList.add("Nakarmi psa", 'A', 2);
    toDoList.add("Nakarmi papug", 'B', 7);
    toDoList.add("Skosi trawnik", 'C', 3);
    toDoList.add("Podla trawnik", 'A', 1);
    toDoList.add("Nakarmi kota", 'B', 1);
    while(!toDoList.isEmpty())
      System.out.println(toDoList.remove());
  }
} /* Output:
A1: Podla trawnik
A2: Nakarmi psa
B1: Nakarmi kota
B7: Nakarmi papug
C3: Skosi trawnik
C4: Wynie mieci
*///:~
