//: containers/SetPerformance.java
// Ilustracja wydajnoci implementacji interfejsu Set.
// {Args: 100 5000} Maa liczba skraca czas dla systemu kompilacji
import java.util.*;

public class SetPerformance {
  static List<Test<Set<Integer>>> tests =
    new ArrayList<Test<Set<Integer>>>();
  static {
    tests.add(new Test<Set<Integer>>("add") {
      int test(Set<Integer> set, TestParam tp) {
        int loops = tp.loops;
        int size = tp.size;
        for(int i = 0; i < loops; i++) {
          set.clear();
          for(int j = 0; j < size; j++)
            set.add(j);
        }
        return loops * size;
      }
    });
    tests.add(new Test<Set<Integer>>("contains") {
      int test(Set<Integer> set, TestParam tp) {
        int loops = tp.loops;
        int span = tp.size * 2;
        for(int i = 0; i < loops; i++)
          for(int j = 0; j < span; j++)
            set.contains(j);
        return loops * span;
      }
    });
    tests.add(new Test<Set<Integer>>("iterate") {
      int test(Set<Integer> set, TestParam tp) {
        int loops = tp.loops * 10;
        for(int i = 0; i < loops; i++) {
          Iterator<Integer> it = set.iterator();
          while(it.hasNext())
            it.next();
        }
        return loops * set.size();
      }
    });
  }
  public static void main(String[] args) {
    if(args.length > 0)
      Tester.defaultParams = TestParam.array(args);
    Tester.fieldWidth = 10;
    Tester.run(new TreeSet<Integer>(), tests);
    Tester.run(new HashSet<Integer>(), tests);
    Tester.run(new LinkedHashSet<Integer>(), tests);
  }
} /* Output: (Sample)
--------------- TreeSet ---------------
 rozmiar       add  contains   iterate
      10       746       173        89
     100       501       264        68
    1000       714       410        69
   10000      1975       552        69
--------------- HashSet ---------------
 rozmiar       add  contains   iterate
      10       308        91        94
     100       178        75        73
    1000       216       110        72
   10000       711       215       100
------------ LinkedHashSet ------------
 rozmiar       add  contains   iterate
      10       350        65        83
     100       270        74        55
    1000       303       111        54
   10000      1615       256        58
*///:~
