//: containers/QueueBehavior.java
// Porwnanie zachowania wybranych kolejek
import java.util.concurrent.*;
import java.util.*;
import net.mindview.util.*;

public class QueueBehavior {
  private static int count = 10;
  static <T> void test(Queue<T> queue, Generator<T> gen) {
    for(int i = 0; i < count; i++)
      queue.offer(gen.next());
    while(queue.peek() != null)
      System.out.print(queue.remove() + " ");
    System.out.println();
  }
  static class Gen implements Generator<String> {
    String[] s = ("jeden dwa trzy cztery pi sze siedem " +
      "osiem dziewi dziesi").split(" ");
    int i;
    public String next() { return s[i++]; }
  }
  public static void main(String[] args) {
    test(new LinkedList<String>(), new Gen());
    test(new PriorityQueue<String>(), new Gen());
    test(new ArrayBlockingQueue<String>(count), new Gen());
    test(new ConcurrentLinkedQueue<String>(), new Gen());
    test(new LinkedBlockingQueue<String>(), new Gen());
    test(new PriorityBlockingQueue<String>(), new Gen());
  }
} /* Output:
jeden dwa trzy cztery pi sze siedem osiem dziewi dziesi 
cztery dwa dziesi dziewi jeden osiem pi siedem sze trzy 
jeden dwa trzy cztery pi sze siedem osiem dziewi dziesi 
jeden dwa trzy cztery pi sze siedem osiem dziewi dziesi 
jeden dwa trzy cztery pi sze siedem osiem dziewi dziesi 
cztery dwa dziesi dziewi jeden osiem pi siedem sze trzy
*///:~
