//: containers/Lists.java
// Co mona zrobi z kontenerami List.
import java.util.*;
import net.mindview.util.*;
import static net.mindview.util.Print.*;

public class Lists {
  private static boolean b;
  private static String s;
  private static int i;
  private static Iterator<String> it;
  private static ListIterator<String> lit;
  public static void basicTest(List<String> a) {
    a.add(1, "x"); // Wstawienie na pozycj 1
    a.add("x"); // Dodanie na koniec
    // Dodanie kolekcji:
    a.addAll(Countries.names(25));
    // Dodanie kolekcji od pozycji 3:
    a.addAll(3, Countries.names(25));
    b = a.contains("1"); // Czy mamy tu taki element??
    // Czy mamy tu tak kolekcj?
    b = a.containsAll(Countries.names(25));
    // Listy obsuguj dostp swobodny -- mao kosztowny dla
    // podtypu ArrayList, kosztowny dla LinkedList:
    s = a.get(1); // Pobranie (typowanego) obiektu z pozycji 1
    i = a.indexOf("1"); // Pobranie indeksu obiektu
    b = a.isEmpty(); // Czy lista zawiera cokolwiek?
    it = a.iterator(); // Zwyczajny iterator
    lit = a.listIterator(); // ListIterator
    lit = a.listIterator(3); // Zaczyna od pozycji 3
    i = a.lastIndexOf("1"); // Ostatnie dopasowanie
    a.remove(1); // Usunicie pozycji 1
    a.remove("3"); // Usunicie danego obiektu
    a.set(1, "y"); // Ustawienie pozycji 1 na "y"
    // Zachowanie elementw wymienionych w ostatnim argumencie
    // (cz wsplna dwch zbiorw):
    a.retainAll(Countries.names(25));
    // Usunicie wszystkiego, co znajduje si w argumencie:
    a.removeAll(Countries.names(25));
    i = a.size(); // Jaki jest rozmiar listy?
    a.clear(); // Usunicie wszystkich elementw
  }
  public static void iterMotion(List<String> a) {
    ListIterator<String> it = a.listIterator();
    b = it.hasNext();
    b = it.hasPrevious();
    s = it.next();
    i = it.nextIndex();
    s = it.previous();
    i = it.previousIndex();
  }
  public static void iterManipulation(List<String> a) {
    ListIterator<String> it = a.listIterator();
    it.add("47");
    // Po add() trzeba przesun iterator na nastpn pozycj:
    it.next();
    // Usunici elementu zza elementu ostatnio dodanego:
    it.remove();
    // Po remove() trzeba przesun iterator na nastpn pozycj:
    it.next();
    // Zmiana elementu za elementem usunitym:
    it.set("47");
  }
  public static void testVisual(List<String> a) {
    print(a);
    List<String> b = Countries.names(25);
    print("b = " + b);
    a.addAll(b);
    a.addAll(b);
    print(a);
    // Wstawianie, usuwanie i zastpowanie elementw
    // za pomoc iteratora ListIterator:
    ListIterator<String> x = a.listIterator(a.size()/2);
    x.add("jeden");
    print(a);
    print(x.next());
    x.remove();
    print(x.next());
    x.set("47");
    print(a);
    // Przegldanie listy wspak:
    x = a.listIterator(a.size());
    while(x.hasPrevious())
      printnb(x.previous() + " ");
    print();
    print("koniec testVisual");
  }
  // Niektre operacjerzeczy potrafi jedynie LinkedList:
  public static void testLinkedList() {
    LinkedList<String> ll = new LinkedList<String>();
    ll.addAll(Countries.names(25));
    print(ll);
    // Jak stos: odkadamy na stos:
    ll.addFirst("jeden");
    ll.addFirst("dwa");
    print(ll);
    // "Podgldanie" szczytu stosu:
    print(ll.getFirst());
    // Zdejmowanie elementu ze stosu:
    print(ll.removeFirst());
    print(ll.removeFirst());
    // Jak kolejka: wyciganie elementw z koca kolejki:
    print(ll.removeLast());
    print(ll);
  }
  public static void main(String[] args) {
    // Za kadym razem tworzy i wypenia now list:
    basicTest(
      new LinkedList<String>(Countries.names(25)));
    basicTest(
      new ArrayList<String>(Countries.names(25)));
    iterMotion(
      new LinkedList<String>(Countries.names(25)));
    iterMotion(
      new ArrayList<String>(Countries.names(25)));
    iterManipulation(
      new LinkedList<String>(Countries.names(25)));
    iterManipulation(
      new ArrayList<String>(Countries.names(25)));
    testVisual(
      new LinkedList<String>(Countries.names(25)));
    testLinkedList();
  }
} /* (Execute to see output) *///:~
