//: containers/ListSortSearch.java
// Sortowanie i wyszukiwanie w listach
// za pomoc oprzyrzdowania Collections.
import java.util.*;
import static net.mindview.util.Print.*;

public class ListSortSearch {
  public static void main(String[] args) {
    List<String> list =
      new ArrayList<String>(Utilities.list);
    list.addAll(Utilities.list);
    print(list);
    Collections.shuffle(list, new Random(47));
    print("Potasowana: " + list);
    // Zastosowanie iteratora ListIterator do obcicia ostatniego elementu:
    ListIterator<String> it = list.listIterator(10);
    while(it.hasNext()) {
      it.next();
      it.remove();
    }
    print("Przycita: " + list);
    Collections.sort(list);
    print("Posortowana: " + list);
    String key = list.get(7);
    int index = Collections.binarySearch(list, key);
    print("Pozycja " + key + " to " + index +
      ", list.get(" + index + ") = " + list.get(index));
    Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
    print("Posortowana (bez rozpoznawania wielkoci znakw): " + list);
    key = list.get(7);
    index = Collections.binarySearch(list, key,
      String.CASE_INSENSITIVE_ORDER);
    print("Pozycja " + key + " to " + index +
      ", list.get(" + index + ") = " + list.get(index));
  }
} /* Output:
[jeden, Dwa, trzy, Cztery, pi, sze, jeden, jeden, Dwa, trzy, Cztery, pi, sze, jeden]
Potasowana: [Cztery, pi, jeden, jeden, Dwa, sze, sze, trzy, trzy, pi, Cztery, Dwa, jeden, jeden]
Przycita: [Cztery, pi, jeden, jeden, Dwa, sze, sze, trzy, trzy, pi]
Posortowana: [Cztery, Dwa, jeden, jeden, pi, pi, sze, sze, trzy, trzy]
Pozycja sze to 7, list.get(7) = sze
Posortowana (bez rozpoznawania wielkoci znakw): [Cztery, Dwa, jeden, jeden, pi, pi, sze, sze, trzy, trzy]
Pozycja sze to 7, list.get(7) = sze
*///:~
