//: concurrency/waxomatic/WaxOMatic.java
// Prosta wsppraca zada.
package concurrency.waxomatic;
import java.util.concurrent.*;
import static net.mindview.util.Print.*;

class Car {
  private boolean waxOn = false;
  public synchronized void waxed() {
    waxOn = true; // Auto gotowe do polerowania
    notifyAll();
  }
  public synchronized void buffed() {
    waxOn = false; // Auto gotowe do naoenia 
                   // nastpnej warstwy wosku
    notifyAll();
  }
  public synchronized void waitForWaxing()
  throws InterruptedException {
    while(waxOn == false)
      wait();
  }
  public synchronized void waitForBuffing()
  throws InterruptedException {
    while(waxOn == true)
      wait();
  }
}

class WaxOn implements Runnable {
  private Car car;
  public WaxOn(Car c) { car = c; }
  public void run() {
    try {
      while(!Thread.interrupted()) {
        printnb("Nawoskowany! ");
        TimeUnit.MILLISECONDS.sleep(200);
        car.waxed();
        car.waitForBuffing();
      }
    } catch(InterruptedException e) {
      print("Wyjcie wymuszone przerwaniem");
    }
    print("Koniec zadania woskowania");
  }
}

class WaxOff implements Runnable {
  private Car car;
  public WaxOff(Car c) { car = c; }
  public void run() {
    try {
      while(!Thread.interrupted()) {
        car.waitForWaxing();
        printnb("Wypolerowany! ");
        TimeUnit.MILLISECONDS.sleep(200);
        car.buffed();
      }
    } catch(InterruptedException e) {
      print("Wyjcie wymuszone przerwaniem");
    }
    print("Koniec zadania polerowania");
  }
}

public class WaxOMatic {
  public static void main(String[] args) throws Exception {
    Car car = new Car();
    ExecutorService exec = Executors.newCachedThreadPool();
    exec.execute(new WaxOff(car));
    exec.execute(new WaxOn(car));
    TimeUnit.SECONDS.sleep(5); // Niech si krci przez jaki czas...
    exec.shutdownNow(); // Przerwanie wszystkich zada
  }
} /* Output: (95% match)
Nawoskowany! Wypolerowany! Nawoskowany! Wypolerowany! Nawoskowany! Wypolerowany! Nawoskowany! Wypolerowany! Nawoskowany! Wypolerowany! Nawoskowany! Wypolerowany! Nawoskowany! Wypolerowany! Nawoskowany! Wypolerowany! Nawoskowany! Wypolerowany! Nawoskowany! Wypolerowany! Nawoskowany! Wypolerowany! Nawoskowany! Wypolerowany! Nawoskowany! Wyjcie wymuszone przerwaniem
Koniec zadania woskowania
Wyjcie wymuszone przerwaniem
Koniec zadania polerowania
*///:~
