//: concurrency/Restaurant.java
// Wspdziaanie zada wedle modelu producent-consument.
import java.util.concurrent.*;
import static net.mindview.util.Print.*;

class Meal {
  private final int orderNum;
  public Meal(int orderNum) { this.orderNum = orderNum; }
  public String toString() { return "Danie " + orderNum; }
}

class WaitPerson implements Runnable {
  private Restaurant restaurant;
  public WaitPerson(Restaurant r) { restaurant = r; }
  public void run() {
    try {
      while(!Thread.interrupted()) {
        synchronized(this) {
          while(restaurant.meal == null)
            wait(); // ... oczekiwanie na efekty pracy kucharza
        }
        print("Kelner odebra danie " + restaurant.meal);
        synchronized(restaurant.chef) {
          restaurant.meal = null;
          restaurant.chef.notifyAll(); // Gotowy do nastpnej tury
        }
      }
    } catch(InterruptedException e) {
      print("Przerwano zadanie kelnera");
    }
  }
}

class Chef implements Runnable {
  private Restaurant restaurant;
  private int count = 0;
  public Chef(Restaurant r) { restaurant = r; }
  public void run() {
    try {
      while(!Thread.interrupted()) {
        synchronized(this) {
          while(restaurant.meal != null)
            wait(); // ... oczekiwanie na odbir dania
        }
        if(++count == 10) {
          print("Koniec zapasw, zamykamy");
          restaurant.exec.shutdownNow();
        }
        printnb("Zrobione! ");
        synchronized(restaurant.waitPerson) {
          restaurant.meal = new Meal(count);
          restaurant.waitPerson.notifyAll();
        }
        TimeUnit.MILLISECONDS.sleep(100);
      }
    } catch(InterruptedException e) {
      print("Przerwane zadanie kucharza");
    }
  }
}

public class Restaurant {
  Meal meal;
  ExecutorService exec = Executors.newCachedThreadPool();
  WaitPerson waitPerson = new WaitPerson(this);
  Chef chef = new Chef(this);
  public Restaurant() {
    exec.execute(chef);
    exec.execute(waitPerson);
  }
  public static void main(String[] args) {
    new Restaurant();
  }
} /* Output:
Zrobione! Kelner odebra danie 1
Zrobione! Kelner odebra danie 2
Zrobione! Kelner odebra danie 3
Zrobione! Kelner odebra danie 4
Zrobione! Kelner odebra danie 5
Zrobione! Kelner odebra danie 6
Zrobione! Kelner odebra danie 7
Zrobione! Kelner odebra danie 8
Zrobione! Kelner odebra danie 9
Koniec zapasw, zamykamy
Przerwano zadanie kelnera
Zrobione! Przerwano zadanie kucharza
*///:~
