//: concurrency/PipedIO.java
// Potoki w subie wymiany danych pomidzy zadaniami
import java.util.concurrent.*;
import java.io.*;
import java.util.*;
import static net.mindview.util.Print.*;

class Sender implements Runnable {
  private Random rand = new Random(47);
  private PipedWriter out = new PipedWriter();
  public PipedWriter getPipedWriter() { return out; }
  public void run() {
    try {
      while(true)
        for(char c = 'A'; c <= 'z'; c++) {
          out.write(c);
          TimeUnit.MILLISECONDS.sleep(rand.nextInt(500));
        }
    } catch(IOException e) {
      print(e + " wyjtek zapisu w klasie Sender");
    } catch(InterruptedException e) {
      print(e + " przerwano zadanie Sender");
    }
  }
}

class Receiver implements Runnable {
  private PipedReader in;
  public Receiver(Sender sender) throws IOException {
    in = new PipedReader(sender.getPipedWriter());
  }
  public void run() {
    try {
      while(true) {
        // Blokowanie do czasu pojawienia si nowych znakw:
        printnb("Odczyt: " + (char)in.read() + ", ");
      }
    } catch(IOException e) {
      print(e + " wyjtek odczytu w klasie Receiver");
    }
  }
}

public class PipedIO {
  public static void main(String[] args) throws Exception {
    Sender sender = new Sender();
    Receiver receiver = new Receiver(sender);
    ExecutorService exec = Executors.newCachedThreadPool();
    exec.execute(sender);
    exec.execute(receiver);
    TimeUnit.SECONDS.sleep(4);
    exec.shutdownNow();
  }
} /* Output: (65% match)
Odczyt: A, Odczyt: B, Odczyt: C, Odczyt: D, Odczyt: E, Odczyt: F, Odczyt: G, Odczyt: H, Odczyt: I, Odczyt: J, Odczyt: K, Odczyt: L, Odczyt: M, java.lang.InterruptedException: sleep interrupted przerwano zadanie Sender
java.io.InterruptedIOException wyjtek odczytu w klasie Receiver
*///:~
