//: concurrency/Philosopher.java
// Ucztujcy filozof
import java.util.concurrent.*;
import java.util.*;
import static net.mindview.util.Print.*;

public class Philosopher implements Runnable {
  private Chopstick left;
  private Chopstick right;
  private final int id;
  private final int ponderFactor;
  private Random rand = new Random(47);
  private void pause() throws InterruptedException {
    if(ponderFactor == 0) return;
    TimeUnit.MILLISECONDS.sleep(
      rand.nextInt(ponderFactor * 250));
  }
  public Philosopher(Chopstick left, Chopstick right,
    int ident, int ponder) {
    this.left = left;
    this.right = right;
    id = ident;
    ponderFactor = ponder;
  }
  public void run() {
    try {
      while(!Thread.interrupted()) {
        print(this + " " + "rozmyla");
        pause();
        // Filozof zgodnia
        print(this + " " + "chwyta praw paeczk");
        right.take();
        print(this + " " + "chwyta lew paeczk");
        left.take();
        print(this + " " + "ucztuje");
        pause();
        right.drop();
        left.drop();
      }
    } catch(InterruptedException e) {
      print(this + " " + "wyjcie wymuszone przerwaniem");
    }
  }
  public String toString() { return "Filozof " + id; }
} ///:~
