//: concurrency/Joining.java
// O co chodzi w join()...
import static net.mindview.util.Print.*;

class Sleeper extends Thread {
  private int duration;
  public Sleeper(String name, int sleepTime) {
    super(name);
    duration = sleepTime;
    start();
  }
  public void run() {
    try {
      sleep(duration);
    } catch(InterruptedException e) {
      print(getName() + " zosta przerwany. " +
        "isInterrupted(): " + isInterrupted());
      return;
    }
    print(getName() + " zosta wybudzony");
  }
}

class Joiner extends Thread {
  private Sleeper sleeper;
  public Joiner(String name, Sleeper sleeper) {
    super(name);
    this.sleeper = sleeper;
    start();
  }
  public void run() {
   try {
      sleeper.join();
    } catch(InterruptedException e) {
      print("Przerwano");
    }
    print(getName() + " zakoczy poczenie");
  }
}

public class Joining {
  public static void main(String[] args) {
    Sleeper
      sleepy = new Sleeper("pioch", 1500),
      grumpy = new Sleeper("Gapcio", 1500);
    Joiner
      dopey = new Joiner("Gburek", sleepy),
      doc = new Joiner("Wesoek", grumpy);
    grumpy.interrupt();
  }
} /* Output:
Gapcio zosta przerwany. isInterrupted(): false
Wesoek zakoczy poczenie
pioch zosta wybudzony
Gburek zakoczy poczenie
*///:~
