//: concurrency/InterruptingIdiom.java
// Oglny schemat obsugi przerywania zadania.
// {Args: 1100}
import java.util.concurrent.*;
import static net.mindview.util.Print.*;

class NeedsCleanup {
  private final int id;
  public NeedsCleanup(int ident) {
    id = ident;
    print("NeedsCleanup " + id);
  }
  public void cleanup() {
    print("Porzdkowanie " + id);
  }
}

class Blocked3 implements Runnable {
  private volatile double d = 0.0;
  public void run() {
    try {
      while(!Thread.interrupted()) {
        // punkt1
        NeedsCleanup n1 = new NeedsCleanup(1);
        // Rozpoczcie bloku try-finally zaraz za definicj
        // n1, w celu zagwarantowania waciwych porzdkw n1:
        try {
          print("Drzemka");
          TimeUnit.SECONDS.sleep(1);
          // punkt2
          NeedsCleanup n2 = new NeedsCleanup(2);
          // Zapewnianie waciwego porzdkowania n2:
          try {
            print("Obliczenia");
            // Czasochonna operacja nieblokujca:
            for(int i = 1; i < 2500000; i++)
              d = d + (Math.PI + Math.E) / d;
            print("Zakoczono czasochonne obliczenia");
          } finally {
            n2.cleanup();
          }
        } finally {
          n1.cleanup();
        }
      }
      print("Wyjcie przewidziane w tecie while()");
    } catch(InterruptedException e) {
      print("Wyjcie wymuszone wyjtkiem InterruptedException");
    }
  }
}

public class InterruptingIdiom {
  public static void main(String[] args) throws Exception {
    if(args.length != 1) {
      print("Stosowanie: java InterruptingIdiom opnienie-w-ms");
      System.exit(1);
    }
    Thread t = new Thread(new Blocked3());
    t.start();
    TimeUnit.MILLISECONDS.sleep(new Integer(args[0]));
    t.interrupt();
  }
} /* Output: (Sample)
NeedsCleanup 1
Drzemka
NeedsCleanup 2
Obliczenia
Zakoczono czasochonne obliczenia
Porzdkowanie 2
Porzdkowanie 1
NeedsCleanup 1
Drzemka
Porzdkowanie 1
Wyjcie wymuszone wyjtkiem InterruptedException
*///:~
